@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A SQL DW table data set.
 * @property dataSetId Unique id for identifying a data set resource
 * @property dataWarehouseName DataWarehouse name of the source data set
 * @property id The resource id of the azure resource
 * @property kind Kind of data set.
 * Expected value is 'SqlDWTable'.
 * @property name Name of the azure resource
 * @property schemaName Schema of the table. Default value is dbo.
 * @property sqlServerResourceId Resource id of SQL server
 * @property systemData System Data of the Azure resource.
 * @property tableName SQL DW table name.
 * @property type Type of the azure resource
 */
public data class GetSqlDWTableDataSetResult(
    public val dataSetId: String,
    public val dataWarehouseName: String,
    public val id: String,
    public val kind: String,
    public val name: String,
    public val schemaName: String,
    public val sqlServerResourceId: String,
    public val systemData: SystemDataResponse,
    public val tableName: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.GetSqlDWTableDataSetResult):
            GetSqlDWTableDataSetResult = GetSqlDWTableDataSetResult(
            dataSetId = javaType.dataSetId(),
            dataWarehouseName = javaType.dataWarehouseName(),
            id = javaType.id(),
            kind = javaType.kind(),
            name = javaType.name(),
            schemaName = javaType.schemaName(),
            sqlServerResourceId = javaType.sqlServerResourceId(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.datashare.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tableName = javaType.tableName(),
            type = javaType.type(),
        )
    }
}
