@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * A ShareSubscriptionSynchronization data transfer object.
 * @property durationMs Synchronization duration
 * @property endTime End time of synchronization
 * @property message message of Synchronization
 * @property startTime start time of synchronization
 * @property status Raw Status
 * @property synchronizationId Synchronization id
 * @property synchronizationMode Synchronization Mode
 */
public data class ShareSubscriptionSynchronizationResponse(
    public val durationMs: Int,
    public val endTime: String,
    public val message: String,
    public val startTime: String,
    public val status: String,
    public val synchronizationId: String,
    public val synchronizationMode: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.ShareSubscriptionSynchronizationResponse):
            ShareSubscriptionSynchronizationResponse = ShareSubscriptionSynchronizationResponse(
            durationMs = javaType.durationMs(),
            endTime = javaType.endTime(),
            message = javaType.message(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            synchronizationId = javaType.synchronizationId(),
            synchronizationMode = javaType.synchronizationMode(),
        )
    }
}
