@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datashare.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Synchronization details at data set level
 * @property dataSetId Id of data set
 * @property dataSetType Type of the data set
 * @property durationMs Duration of data set level copy
 * @property endTime End time of data set level copy
 * @property filesRead The number of files read from the source data set
 * @property filesWritten The number of files written into the sink data set
 * @property message Error message if any
 * @property name Name of the data set
 * @property rowsCopied The number of files copied into the sink data set
 * @property rowsRead The number of rows read from the source data set.
 * @property sizeRead The size of the data read from the source data set in bytes
 * @property sizeWritten The size of the data written into the sink data set in bytes
 * @property startTime Start time of data set level copy
 * @property status Raw Status
 * @property vCore The vCore units consumed for the data set synchronization
 */
public data class SynchronizationDetailsResponse(
    public val dataSetId: String,
    public val dataSetType: String,
    public val durationMs: Int,
    public val endTime: String,
    public val filesRead: Double,
    public val filesWritten: Double,
    public val message: String,
    public val name: String,
    public val rowsCopied: Double,
    public val rowsRead: Double,
    public val sizeRead: Double,
    public val sizeWritten: Double,
    public val startTime: String,
    public val status: String,
    public val vCore: Double,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datashare.outputs.SynchronizationDetailsResponse):
            SynchronizationDetailsResponse = SynchronizationDetailsResponse(
            dataSetId = javaType.dataSetId(),
            dataSetType = javaType.dataSetType(),
            durationMs = javaType.durationMs(),
            endTime = javaType.endTime(),
            filesRead = javaType.filesRead(),
            filesWritten = javaType.filesWritten(),
            message = javaType.message(),
            name = javaType.name(),
            rowsCopied = javaType.rowsCopied(),
            rowsRead = javaType.rowsRead(),
            sizeRead = javaType.sizeRead(),
            sizeWritten = javaType.sizeWritten(),
            startTime = javaType.startTime(),
            status = javaType.status(),
            vCore = javaType.vCore(),
        )
    }
}
