@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [FirewallRule].
 */
@PulumiTagMarker
public class FirewallRuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FirewallRuleArgs = FirewallRuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FirewallRuleArgsBuilder.() -> Unit) {
        val builder = FirewallRuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FirewallRule {
        val builtJavaResource =
            com.pulumi.azurenative.dbformariadb.FirewallRule(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return FirewallRule(builtJavaResource)
    }
}

/**
 * Represents a server firewall rule.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### FirewallRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DBforMariaDB.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "255.255.255.255",
 *         FirewallRuleName = "rule1",
 *         ResourceGroupName = "TestGroup",
 *         ServerName = "testserver",
 *         StartIpAddress = "0.0.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewFirewallRule(ctx, "firewallRule", &dbformariadb.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("255.255.255.255"),
 * 			FirewallRuleName:  pulumi.String("rule1"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			StartIpAddress:    pulumi.String("0.0.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.FirewallRule;
 * import com.pulumi.azurenative.dbformariadb.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("255.255.255.255")
 *             .firewallRuleName("rule1")
 *             .resourceGroupName("TestGroup")
 *             .serverName("testserver")
 *             .startIpAddress("0.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:FirewallRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}/firewallRules/{firewallRuleName}
 * ```
 */
public class FirewallRule internal constructor(
    override val javaResource: com.pulumi.azurenative.dbformariadb.FirewallRule,
) : KotlinCustomResource(javaResource, FirewallRuleMapper) {
    /**
     * The end IP address of the server firewall rule. Must be IPv4 format.
     */
    public val endIpAddress: Output<String>
        get() = javaResource.endIpAddress().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The start IP address of the server firewall rule. Must be IPv4 format.
     */
    public val startIpAddress: Output<String>
        get() = javaResource.startIpAddress().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object FirewallRuleMapper : ResourceMapper<FirewallRule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.dbformariadb.FirewallRule::class == javaResource::class

    override fun map(javaResource: Resource): FirewallRule = FirewallRule(
        javaResource as
            com.pulumi.azurenative.dbformariadb.FirewallRule,
    )
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FirewallRule].
 */
public suspend fun firewallRule(
    name: String,
    block: suspend FirewallRuleResourceBuilder.() -> Unit,
): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FirewallRule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun firewallRule(name: String): FirewallRule {
    val builder = FirewallRuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
