@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin

import com.pulumi.azurenative.dbformariadb.FirewallRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a server firewall rule.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * Other available API versions: 2018-06-01-preview.
 * ## Example Usage
 * ### FirewallRuleCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var firewallRule = new AzureNative.DBforMariaDB.FirewallRule("firewallRule", new()
 *     {
 *         EndIpAddress = "255.255.255.255",
 *         FirewallRuleName = "rule1",
 *         ResourceGroupName = "TestGroup",
 *         ServerName = "testserver",
 *         StartIpAddress = "0.0.0.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbformariadb/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbformariadb.NewFirewallRule(ctx, "firewallRule", &dbformariadb.FirewallRuleArgs{
 * 			EndIpAddress:      pulumi.String("255.255.255.255"),
 * 			FirewallRuleName:  pulumi.String("rule1"),
 * 			ResourceGroupName: pulumi.String("TestGroup"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			StartIpAddress:    pulumi.String("0.0.0.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbformariadb.FirewallRule;
 * import com.pulumi.azurenative.dbformariadb.FirewallRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var firewallRule = new FirewallRule("firewallRule", FirewallRuleArgs.builder()
 *             .endIpAddress("255.255.255.255")
 *             .firewallRuleName("rule1")
 *             .resourceGroupName("TestGroup")
 *             .serverName("testserver")
 *             .startIpAddress("0.0.0.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbformariadb:FirewallRule rule1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforMariaDB/servers/{serverName}/firewallRules/{firewallRuleName}
 * ```
 * @property endIpAddress The end IP address of the server firewall rule. Must be IPv4 format.
 * @property firewallRuleName The name of the server firewall rule.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property startIpAddress The start IP address of the server firewall rule. Must be IPv4 format.
 */
public data class FirewallRuleArgs(
    public val endIpAddress: Output<String>? = null,
    public val firewallRuleName: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val startIpAddress: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformariadb.FirewallRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformariadb.FirewallRuleArgs =
        com.pulumi.azurenative.dbformariadb.FirewallRuleArgs.builder()
            .endIpAddress(endIpAddress?.applyValue({ args0 -> args0 }))
            .firewallRuleName(firewallRuleName?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .startIpAddress(startIpAddress?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallRuleArgs].
 */
@PulumiTagMarker
public class FirewallRuleArgsBuilder internal constructor() {
    private var endIpAddress: Output<String>? = null

    private var firewallRuleName: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var startIpAddress: Output<String>? = null

    /**
     * @param value The end IP address of the server firewall rule. Must be IPv4 format.
     */
    @JvmName("svdyapwiipgisssk")
    public suspend fun endIpAddress(`value`: Output<String>) {
        this.endIpAddress = value
    }

    /**
     * @param value The name of the server firewall rule.
     */
    @JvmName("tarrhsuietnjdier")
    public suspend fun firewallRuleName(`value`: Output<String>) {
        this.firewallRuleName = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("sntfxdfrwtscsatx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("fjminotovpsbijuf")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The start IP address of the server firewall rule. Must be IPv4 format.
     */
    @JvmName("calgiefaxitrogok")
    public suspend fun startIpAddress(`value`: Output<String>) {
        this.startIpAddress = value
    }

    /**
     * @param value The end IP address of the server firewall rule. Must be IPv4 format.
     */
    @JvmName("umqpylugehigtpvl")
    public suspend fun endIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endIpAddress = mapped
    }

    /**
     * @param value The name of the server firewall rule.
     */
    @JvmName("jnuecgqhvswjwilj")
    public suspend fun firewallRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firewallRuleName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("acpxrbufuetrkgio")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("uqmmsulhjlpcwuwl")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The start IP address of the server firewall rule. Must be IPv4 format.
     */
    @JvmName("vnvafxlhkseqevmy")
    public suspend fun startIpAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startIpAddress = mapped
    }

    internal fun build(): FirewallRuleArgs = FirewallRuleArgs(
        endIpAddress = endIpAddress,
        firewallRuleName = firewallRuleName,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        startIpAddress = startIpAddress,
    )
}
