@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.inputs

import com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForDefaultCreateArgs.builder
import com.pulumi.azurenative.dbformariadb.kotlin.enums.MinimalTlsVersionEnum
import com.pulumi.azurenative.dbformariadb.kotlin.enums.PublicNetworkAccessEnum
import com.pulumi.azurenative.dbformariadb.kotlin.enums.ServerVersion
import com.pulumi.azurenative.dbformariadb.kotlin.enums.SslEnforcementEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The properties used to create a new server.
 * @property administratorLogin The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
 * @property administratorLoginPassword The password of the administrator login.
 * @property createMode The mode to create a new server.
 * Expected value is 'Default'.
 * @property minimalTlsVersion Enforce a minimal Tls version for the server.
 * @property publicNetworkAccess Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
 * @property sslEnforcement Enable ssl enforcement or not when connect to server.
 * @property storageProfile Storage profile of a server.
 * @property version Server version.
 */
public data class ServerPropertiesForDefaultCreateArgs(
    public val administratorLogin: Output<String>,
    public val administratorLoginPassword: Output<String>,
    public val createMode: Output<String>,
    public val minimalTlsVersion: Output<Either<String, MinimalTlsVersionEnum>>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccessEnum>>? = null,
    public val sslEnforcement: Output<SslEnforcementEnum>? = null,
    public val storageProfile: Output<StorageProfileArgs>? = null,
    public val version: Output<Either<String, ServerVersion>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForDefaultCreateArgs> {
    override fun toJava():
        com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForDefaultCreateArgs =
        com.pulumi.azurenative.dbformariadb.inputs.ServerPropertiesForDefaultCreateArgs.builder()
            .administratorLogin(administratorLogin.applyValue({ args0 -> args0 }))
            .administratorLoginPassword(administratorLoginPassword.applyValue({ args0 -> args0 }))
            .createMode(createMode.applyValue({ args0 -> args0 }))
            .minimalTlsVersion(
                minimalTlsVersion?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .publicNetworkAccess(
                publicNetworkAccess?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .sslEnforcement(sslEnforcement?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .storageProfile(storageProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(
                version?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ServerPropertiesForDefaultCreateArgs].
 */
@PulumiTagMarker
public class ServerPropertiesForDefaultCreateArgsBuilder internal constructor() {
    private var administratorLogin: Output<String>? = null

    private var administratorLoginPassword: Output<String>? = null

    private var createMode: Output<String>? = null

    private var minimalTlsVersion: Output<Either<String, MinimalTlsVersionEnum>>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccessEnum>>? = null

    private var sslEnforcement: Output<SslEnforcementEnum>? = null

    private var storageProfile: Output<StorageProfileArgs>? = null

    private var version: Output<Either<String, ServerVersion>>? = null

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("tktklngthtsjkcls")
    public suspend fun administratorLogin(`value`: Output<String>) {
        this.administratorLogin = value
    }

    /**
     * @param value The password of the administrator login.
     */
    @JvmName("eatxjgxpthjvmafa")
    public suspend fun administratorLoginPassword(`value`: Output<String>) {
        this.administratorLoginPassword = value
    }

    /**
     * @param value The mode to create a new server.
     * Expected value is 'Default'.
     */
    @JvmName("noitsofyadddbxqe")
    public suspend fun createMode(`value`: Output<String>) {
        this.createMode = value
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("eaxbkbvpafsqaewf")
    public suspend fun minimalTlsVersion(`value`: Output<Either<String, MinimalTlsVersionEnum>>) {
        this.minimalTlsVersion = value
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("etsrxloccwpvggjp")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccessEnum>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value Enable ssl enforcement or not when connect to server.
     */
    @JvmName("imhatykuahdvlabk")
    public suspend fun sslEnforcement(`value`: Output<SslEnforcementEnum>) {
        this.sslEnforcement = value
    }

    /**
     * @param value Storage profile of a server.
     */
    @JvmName("ijyelraaytvericv")
    public suspend fun storageProfile(`value`: Output<StorageProfileArgs>) {
        this.storageProfile = value
    }

    /**
     * @param value Server version.
     */
    @JvmName("ushshphimrcxpviy")
    public suspend fun version(`value`: Output<Either<String, ServerVersion>>) {
        this.version = value
    }

    /**
     * @param value The administrator's login name of a server. Can only be specified when the server is being created (and is required for creation).
     */
    @JvmName("tlgktaccbuxqcqfu")
    public suspend fun administratorLogin(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorLogin = mapped
    }

    /**
     * @param value The password of the administrator login.
     */
    @JvmName("djkbykkqigrjaxwq")
    public suspend fun administratorLoginPassword(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.administratorLoginPassword = mapped
    }

    /**
     * @param value The mode to create a new server.
     * Expected value is 'Default'.
     */
    @JvmName("piixpqtrxhwiotpg")
    public suspend fun createMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.createMode = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("uadvilnexgtrkqet")
    public suspend fun minimalTlsVersion(`value`: Either<String, MinimalTlsVersionEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("qvtasswvmttcjbgc")
    public fun minimalTlsVersion(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MinimalTlsVersionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Enforce a minimal Tls version for the server.
     */
    @JvmName("lromxrwnrinqgxbj")
    public fun minimalTlsVersion(`value`: MinimalTlsVersionEnum) {
        val toBeMapped = Either.ofRight<String, MinimalTlsVersionEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minimalTlsVersion = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("qtvakngylquxsxva")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccessEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("hnylffarehvrqqbr")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccessEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Whether or not public network access is allowed for this server. Value is optional but if passed in, must be 'Enabled' or 'Disabled'
     */
    @JvmName("fmwitepmkjoesmwn")
    public fun publicNetworkAccess(`value`: PublicNetworkAccessEnum) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccessEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Enable ssl enforcement or not when connect to server.
     */
    @JvmName("umaeebganubhwshf")
    public suspend fun sslEnforcement(`value`: SslEnforcementEnum?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sslEnforcement = mapped
    }

    /**
     * @param value Storage profile of a server.
     */
    @JvmName("kkpbenrhiypygcxw")
    public suspend fun storageProfile(`value`: StorageProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageProfile = mapped
    }

    /**
     * @param argument Storage profile of a server.
     */
    @JvmName("pybeiykavgspngtk")
    public suspend fun storageProfile(argument: suspend StorageProfileArgsBuilder.() -> Unit) {
        val toBeMapped = StorageProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.storageProfile = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("sqsvmntrengtwlla")
    public suspend fun version(`value`: Either<String, ServerVersion>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("ijjwtsfnrxrbdbqi")
    public fun version(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    /**
     * @param value Server version.
     */
    @JvmName("ynxwaejrdjsxsrvv")
    public fun version(`value`: ServerVersion) {
        val toBeMapped = Either.ofRight<String, ServerVersion>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ServerPropertiesForDefaultCreateArgs = ServerPropertiesForDefaultCreateArgs(
        administratorLogin = administratorLogin ?: throw PulumiNullFieldException("administratorLogin"),
        administratorLoginPassword = administratorLoginPassword ?: throw
            PulumiNullFieldException("administratorLoginPassword"),
        createMode = createMode ?: throw PulumiNullFieldException("createMode"),
        minimalTlsVersion = minimalTlsVersion,
        publicNetworkAccess = publicNetworkAccess,
        sslEnforcement = sslEnforcement,
        storageProfile = storageProfile,
        version = version,
    )
}
