@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Configuration.
 * @property allowedValues Allowed values of the configuration.
 * @property dataType Data type of the configuration.
 * @property defaultValue Default value of the configuration.
 * @property description Description of the configuration.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property source Source of the configuration.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Value of the configuration.
 */
public data class GetConfigurationResult(
    public val allowedValues: String,
    public val dataType: String,
    public val defaultValue: String,
    public val description: String,
    public val id: String,
    public val name: String,
    public val source: String? = null,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.GetConfigurationResult):
            GetConfigurationResult = GetConfigurationResult(
            allowedValues = javaType.allowedValues(),
            dataType = javaType.dataType(),
            defaultValue = javaType.defaultValue(),
            description = javaType.description(),
            id = javaType.id(),
            name = javaType.name(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
