@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformariadb.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A virtual network rule.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property ignoreMissingVnetServiceEndpoint Create firewall rule before the virtual network has vnet service endpoint enabled.
 * @property name The name of the resource
 * @property state Virtual Network Rule State
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualNetworkSubnetId The ARM resource id of the virtual network subnet.
 */
public data class GetVirtualNetworkRuleResult(
    public val id: String,
    public val ignoreMissingVnetServiceEndpoint: Boolean? = null,
    public val name: String,
    public val state: String,
    public val type: String,
    public val virtualNetworkSubnetId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformariadb.outputs.GetVirtualNetworkRuleResult):
            GetVirtualNetworkRuleResult = GetVirtualNetworkRuleResult(
            id = javaType.id(),
            ignoreMissingVnetServiceEndpoint = javaType.ignoreMissingVnetServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            name = javaType.name(),
            state = javaType.state(),
            type = javaType.type(),
            virtualNetworkSubnetId = javaType.virtualNetworkSubnetId(),
        )
    }
}
