@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin

import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getAzureADAdministratorPlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getConfigurationPlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getDatabasePlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getFirewallRulePlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getGetPrivateDnsZoneSuffixExecutePlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.dbformysql.DbformysqlFunctions.getServerPlain
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetAzureADAdministratorPlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetAzureADAdministratorPlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetConfigurationPlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetConfigurationPlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetDatabasePlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetDatabasePlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetFirewallRulePlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetFirewallRulePlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetServerPlainArgs
import com.pulumi.azurenative.dbformysql.kotlin.inputs.GetServerPlainArgsBuilder
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetAzureADAdministratorResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetConfigurationResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetDatabaseResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetFirewallRuleResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetGetPrivateDnsZoneSuffixExecuteResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetServerResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetAzureADAdministratorResult.Companion.toKotlin as getAzureADAdministratorResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetConfigurationResult.Companion.toKotlin as getConfigurationResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetDatabaseResult.Companion.toKotlin as getDatabaseResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetFirewallRuleResult.Companion.toKotlin as getFirewallRuleResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetGetPrivateDnsZoneSuffixExecuteResult.Companion.toKotlin as getGetPrivateDnsZoneSuffixExecuteResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.dbformysql.kotlin.outputs.GetServerResult.Companion.toKotlin as getServerResultToKotlin

public object DbformysqlFunctions {
    /**
     * Gets information about an azure ad administrator.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2023-06-01-preview, 2023-06-30.
     * @param argument null
     * @return Represents a Administrator.
     */
    public suspend fun getAzureADAdministrator(argument: GetAzureADAdministratorPlainArgs):
        GetAzureADAdministratorResult =
        getAzureADAdministratorResultToKotlin(getAzureADAdministratorPlain(argument.toJava()).await())

    /**
     * @see [getAzureADAdministrator].
     * @param administratorName The name of the Azure AD Administrator.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Administrator.
     */
    public suspend fun getAzureADAdministrator(
        administratorName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetAzureADAdministratorResult {
        val argument = GetAzureADAdministratorPlainArgs(
            administratorName = administratorName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getAzureADAdministratorResultToKotlin(getAzureADAdministratorPlain(argument.toJava()).await())
    }

    /**
     * @see [getAzureADAdministrator].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetAzureADAdministratorPlainArgs].
     * @return Represents a Administrator.
     */
    public suspend
    fun getAzureADAdministrator(argument: suspend GetAzureADAdministratorPlainArgsBuilder.() -> Unit):
        GetAzureADAdministratorResult {
        val builder = GetAzureADAdministratorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAzureADAdministratorResultToKotlin(getAzureADAdministratorPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a configuration of server.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2017-12-01, 2020-07-01-privatepreview, 2023-06-01-preview, 2023-06-30.
     * @param argument null
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(argument: GetConfigurationPlainArgs): GetConfigurationResult =
        getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())

    /**
     * @see [getConfiguration].
     * @param configurationName The name of the server configuration.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Configuration.
     */
    public suspend fun getConfiguration(
        configurationName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetConfigurationResult {
        val argument = GetConfigurationPlainArgs(
            configurationName = configurationName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getConfigurationResultToKotlin(getConfigurationPlain(argument.toJava()).await())
    }

    /**
     * @see [getConfiguration].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetConfigurationPlainArgs].
     * @return Represents a Configuration.
     */
    public suspend
    fun getConfiguration(argument: suspend GetConfigurationPlainArgsBuilder.() -> Unit):
        GetConfigurationResult {
        val builder = GetConfigurationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getConfigurationResultToKotlin(getConfigurationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a database.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2017-12-01, 2023-06-01-preview, 2023-06-30.
     * @param argument null
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: GetDatabasePlainArgs): GetDatabaseResult =
        getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())

    /**
     * @see [getDatabase].
     * @param databaseName The name of the database.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a Database.
     */
    public suspend fun getDatabase(
        databaseName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetDatabaseResult {
        val argument = GetDatabasePlainArgs(
            databaseName = databaseName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getDatabaseResultToKotlin(getDatabasePlain(argument.toJava()).await())
    }

    /**
     * @see [getDatabase].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetDatabasePlainArgs].
     * @return Represents a Database.
     */
    public suspend fun getDatabase(argument: suspend GetDatabasePlainArgsBuilder.() -> Unit):
        GetDatabaseResult {
        val builder = GetDatabasePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatabaseResultToKotlin(getDatabasePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a server firewall rule.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2017-12-01, 2023-06-01-preview, 2023-06-30.
     * @param argument null
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: GetFirewallRulePlainArgs): GetFirewallRuleResult =
        getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())

    /**
     * @see [getFirewallRule].
     * @param firewallRuleName The name of the server firewall rule.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(
        firewallRuleName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetFirewallRuleResult {
        val argument = GetFirewallRulePlainArgs(
            firewallRuleName = firewallRuleName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getFirewallRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetFirewallRulePlainArgs].
     * @return Represents a server firewall rule.
     */
    public suspend fun getFirewallRule(argument: suspend GetFirewallRulePlainArgsBuilder.() -> Unit):
        GetFirewallRuleResult {
        val builder = GetFirewallRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFirewallRuleResultToKotlin(getFirewallRulePlain(builtArgument.toJava()).await())
    }

    /**
     * Get private DNS zone suffix in the cloud.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2021-05-01, 2021-05-01-preview, 2021-12-01-preview, 2022-09-30-preview, 2023-06-01-preview, 2023-06-30.
     * @param argument null
     * @return The response of get private dns zone suffix.
     */
    public suspend fun getGetPrivateDnsZoneSuffixExecute(): GetGetPrivateDnsZoneSuffixExecuteResult =
        getGetPrivateDnsZoneSuffixExecuteResultToKotlin(getGetPrivateDnsZoneSuffixExecutePlain().await())

    /**
     * Gets a private endpoint connection.
     * Azure REST API version: 2022-09-30-preview.
     * Other available API versions: 2018-06-01-privatepreview, 2023-06-30.
     * @param argument null
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param privateEndpointConnectionName The name of the private endpoint connection.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        privateEndpointConnectionName: String,
        resourceGroupName: String,
        serverName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets information about a server.
     * Azure REST API version: 2022-01-01.
     * Other available API versions: 2017-12-01, 2018-06-01-privatepreview, 2020-07-01-preview, 2020-07-01-privatepreview, 2022-09-30-preview, 2023-06-01-preview, 2023-06-30, 2023-10-01-preview.
     * @param argument null
     * @return Represents a server.
     */
    public suspend fun getServer(argument: GetServerPlainArgs): GetServerResult =
        getServerResultToKotlin(getServerPlain(argument.toJava()).await())

    /**
     * @see [getServer].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serverName The name of the server.
     * @return Represents a server.
     */
    public suspend fun getServer(resourceGroupName: String, serverName: String): GetServerResult {
        val argument = GetServerPlainArgs(
            resourceGroupName = resourceGroupName,
            serverName = serverName,
        )
        return getServerResultToKotlin(getServerPlain(argument.toJava()).await())
    }

    /**
     * @see [getServer].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;dbformysql&#46;kotlin&#46;inputs&#46;GetServerPlainArgs].
     * @return Represents a server.
     */
    public suspend fun getServer(argument: suspend GetServerPlainArgsBuilder.() -> Unit):
        GetServerResult {
        val builder = GetServerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServerResultToKotlin(getServerPlain(builtArgument.toJava()).await())
    }
}
