@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.BackupArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.EnableStatusEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage Profile properties of a server
 * @property backupRetentionDays Backup retention days for the server.
 * @property geoRedundantBackup Whether or not geo redundant backup is enabled.
 */
public data class BackupArgs(
    public val backupRetentionDays: Output<Int>? = null,
    public val geoRedundantBackup: Output<Either<String, EnableStatusEnum>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.BackupArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.BackupArgs =
        com.pulumi.azurenative.dbformysql.inputs.BackupArgs.builder()
            .backupRetentionDays(backupRetentionDays?.applyValue({ args0 -> args0 }))
            .geoRedundantBackup(
                geoRedundantBackup?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [BackupArgs].
 */
@PulumiTagMarker
public class BackupArgsBuilder internal constructor() {
    private var backupRetentionDays: Output<Int>? = null

    private var geoRedundantBackup: Output<Either<String, EnableStatusEnum>>? = null

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("giwewbbqftqsqhdl")
    public suspend fun backupRetentionDays(`value`: Output<Int>) {
        this.backupRetentionDays = value
    }

    /**
     * @param value Whether or not geo redundant backup is enabled.
     */
    @JvmName("lrkeowviomgagrjt")
    public suspend fun geoRedundantBackup(`value`: Output<Either<String, EnableStatusEnum>>) {
        this.geoRedundantBackup = value
    }

    /**
     * @param value Backup retention days for the server.
     */
    @JvmName("esytrhsgioxeugdc")
    public suspend fun backupRetentionDays(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.backupRetentionDays = mapped
    }

    /**
     * @param value Whether or not geo redundant backup is enabled.
     */
    @JvmName("edklighoamgwqafd")
    public suspend fun geoRedundantBackup(`value`: Either<String, EnableStatusEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value Whether or not geo redundant backup is enabled.
     */
    @JvmName("lngltrevdsupklyj")
    public fun geoRedundantBackup(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    /**
     * @param value Whether or not geo redundant backup is enabled.
     */
    @JvmName("ypqmanhcusipwvhv")
    public fun geoRedundantBackup(`value`: EnableStatusEnum) {
        val toBeMapped = Either.ofRight<String, EnableStatusEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.geoRedundantBackup = mapped
    }

    internal fun build(): BackupArgs = BackupArgs(
        backupRetentionDays = backupRetentionDays,
        geoRedundantBackup = geoRedundantBackup,
    )
}
