@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.GetServerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class GetServerPlainArgs(
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.GetServerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.GetServerPlainArgs =
        com.pulumi.azurenative.dbformysql.inputs.GetServerPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServerPlainArgs].
 */
@PulumiTagMarker
public class GetServerPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("idmlijjqnbeqbjjd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("rapbcyhjkmhtktqi")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetServerPlainArgs = GetServerPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
