@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.inputs

import com.pulumi.azurenative.dbformysql.inputs.HighAvailabilityArgs.builder
import com.pulumi.azurenative.dbformysql.kotlin.enums.HighAvailabilityMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network related properties of a server
 * @property mode High availability mode for a server.
 * @property standbyAvailabilityZone Availability zone of the standby server.
 */
public data class HighAvailabilityArgs(
    public val mode: Output<Either<String, HighAvailabilityMode>>? = null,
    public val standbyAvailabilityZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbformysql.inputs.HighAvailabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.dbformysql.inputs.HighAvailabilityArgs =
        com.pulumi.azurenative.dbformysql.inputs.HighAvailabilityArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .standbyAvailabilityZone(standbyAvailabilityZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HighAvailabilityArgs].
 */
@PulumiTagMarker
public class HighAvailabilityArgsBuilder internal constructor() {
    private var mode: Output<Either<String, HighAvailabilityMode>>? = null

    private var standbyAvailabilityZone: Output<String>? = null

    /**
     * @param value High availability mode for a server.
     */
    @JvmName("dhjqyqqahlowmnmp")
    public suspend fun mode(`value`: Output<Either<String, HighAvailabilityMode>>) {
        this.mode = value
    }

    /**
     * @param value Availability zone of the standby server.
     */
    @JvmName("umdpttangwhiysey")
    public suspend fun standbyAvailabilityZone(`value`: Output<String>) {
        this.standbyAvailabilityZone = value
    }

    /**
     * @param value High availability mode for a server.
     */
    @JvmName("xshhygfauefttfnm")
    public suspend fun mode(`value`: Either<String, HighAvailabilityMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value High availability mode for a server.
     */
    @JvmName("bqbbrfgpulrqshgr")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HighAvailabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value High availability mode for a server.
     */
    @JvmName("jcrviswpwagixgfy")
    public fun mode(`value`: HighAvailabilityMode) {
        val toBeMapped = Either.ofRight<String, HighAvailabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value Availability zone of the standby server.
     */
    @JvmName("aqlfvwiitotkriox")
    public suspend fun standbyAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyAvailabilityZone = mapped
    }

    internal fun build(): HighAvailabilityArgs = HighAvailabilityArgs(
        mode = mode,
        standbyAvailabilityZone = standbyAvailabilityZone,
    )
}
