@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a Configuration.
 * @property allowedValues Allowed values of the configuration.
 * @property currentValue Current value of the configuration.
 * @property dataType Data type of the configuration.
 * @property defaultValue Default value of the configuration.
 * @property description Description of the configuration.
 * @property documentationLink The link used to get the document from community or Azure site.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isConfigPendingRestart If is the configuration pending restart or not.
 * @property isDynamicConfig If is the configuration dynamic.
 * @property isReadOnly If is the configuration read only.
 * @property name The name of the resource
 * @property source Source of the configuration.
 * @property systemData The system metadata relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property value Value of the configuration.
 */
public data class GetConfigurationResult(
    public val allowedValues: String,
    public val currentValue: String? = null,
    public val dataType: String,
    public val defaultValue: String,
    public val description: String,
    public val documentationLink: String,
    public val id: String,
    public val isConfigPendingRestart: String,
    public val isDynamicConfig: String,
    public val isReadOnly: String,
    public val name: String,
    public val source: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.GetConfigurationResult):
            GetConfigurationResult = GetConfigurationResult(
            allowedValues = javaType.allowedValues(),
            currentValue = javaType.currentValue().map({ args0 -> args0 }).orElse(null),
            dataType = javaType.dataType(),
            defaultValue = javaType.defaultValue(),
            description = javaType.description(),
            documentationLink = javaType.documentationLink(),
            id = javaType.id(),
            isConfigPendingRestart = javaType.isConfigPendingRestart(),
            isDynamicConfig = javaType.isDynamicConfig(),
            isReadOnly = javaType.isReadOnly(),
            name = javaType.name(),
            source = javaType.source().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.dbformysql.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
