@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Network related properties of a server
 * @property delegatedSubnetResourceId Delegated subnet resource id used to setup vnet for a server.
 * @property privateDnsZoneResourceId Private DNS zone resource id.
 * @property publicNetworkAccess Whether or not public network access is allowed for this server. Value is 'Disabled' when server has VNet integration.
 */
public data class NetworkResponse(
    public val delegatedSubnetResourceId: String? = null,
    public val privateDnsZoneResourceId: String? = null,
    public val publicNetworkAccess: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.NetworkResponse):
            NetworkResponse = NetworkResponse(
            delegatedSubnetResourceId = javaType.delegatedSubnetResourceId().map({ args0 ->
                args0
            }).orElse(null),
            privateDnsZoneResourceId = javaType.privateDnsZoneResourceId().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess(),
        )
    }
}
