@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbformysql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata of user assigned identity.
 * @property clientId Client Id of user assigned identity
 * @property principalId Principal Id of user assigned identity
 */
public data class UserAssignedIdentityResponse(
    public val clientId: String,
    public val principalId: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbformysql.outputs.UserAssignedIdentityResponse):
            UserAssignedIdentityResponse = UserAssignedIdentityResponse(
            clientId = javaType.clientId(),
            principalId = javaType.principalId(),
        )
    }
}
