@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin

import com.pulumi.azurenative.dbforpostgresql.AdministratorArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.PrincipalType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents an Active Directory administrator.
 * Azure REST API version: 2022-12-01.
 * Other available API versions: 2023-03-01-preview, 2023-06-01-preview.
 * ## Example Usage
 * ### Adds an Active DIrectory Administrator for the server
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var administrator = new AzureNative.DBforPostgreSQL.Administrator("administrator", new()
 *     {
 *         ObjectId = "oooooooo-oooo-oooo-oooo-oooooooooooo",
 *         PrincipalName = "testuser1@microsoft.com",
 *         PrincipalType = "User",
 *         ResourceGroupName = "testrg",
 *         ServerName = "testserver",
 *         TenantId = "tttttttt-tttt-tttt-tttt-tttttttttttt",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/dbforpostgresql/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dbforpostgresql.NewAdministrator(ctx, "administrator", &dbforpostgresql.AdministratorArgs{
 * 			ObjectId:          pulumi.String("oooooooo-oooo-oooo-oooo-oooooooooooo"),
 * 			PrincipalName:     pulumi.String("testuser1@microsoft.com"),
 * 			PrincipalType:     pulumi.String("User"),
 * 			ResourceGroupName: pulumi.String("testrg"),
 * 			ServerName:        pulumi.String("testserver"),
 * 			TenantId:          pulumi.String("tttttttt-tttt-tttt-tttt-tttttttttttt"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.dbforpostgresql.Administrator;
 * import com.pulumi.azurenative.dbforpostgresql.AdministratorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var administrator = new Administrator("administrator", AdministratorArgs.builder()
 *             .objectId("oooooooo-oooo-oooo-oooo-oooooooooooo")
 *             .principalName("testuser1@microsoft.com")
 *             .principalType("User")
 *             .resourceGroupName("testrg")
 *             .serverName("testserver")
 *             .tenantId("tttttttt-tttt-tttt-tttt-tttttttttttt")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:dbforpostgresql:Administrator testuser1@microsoft.com /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DBforPostgreSQL/flexibleServers/{serverName}/administrators/{objectId}
 * ```
 * @property objectId Guid of the objectId for the administrator.
 * @property principalName Active Directory administrator principal name.
 * @property principalType The principal type used to represent the type of Active Directory Administrator.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 * @property tenantId The tenantId of the Active Directory administrator.
 */
public data class AdministratorArgs(
    public val objectId: Output<String>? = null,
    public val principalName: Output<String>? = null,
    public val principalType: Output<Either<String, PrincipalType>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serverName: Output<String>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.AdministratorArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.AdministratorArgs =
        com.pulumi.azurenative.dbforpostgresql.AdministratorArgs.builder()
            .objectId(objectId?.applyValue({ args0 -> args0 }))
            .principalName(principalName?.applyValue({ args0 -> args0 }))
            .principalType(
                principalType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serverName(serverName?.applyValue({ args0 -> args0 }))
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AdministratorArgs].
 */
@PulumiTagMarker
public class AdministratorArgsBuilder internal constructor() {
    private var objectId: Output<String>? = null

    private var principalName: Output<String>? = null

    private var principalType: Output<Either<String, PrincipalType>>? = null

    private var resourceGroupName: Output<String>? = null

    private var serverName: Output<String>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value Guid of the objectId for the administrator.
     */
    @JvmName("ppemwhddvofposjs")
    public suspend fun objectId(`value`: Output<String>) {
        this.objectId = value
    }

    /**
     * @param value Active Directory administrator principal name.
     */
    @JvmName("slinpgfsywosueud")
    public suspend fun principalName(`value`: Output<String>) {
        this.principalName = value
    }

    /**
     * @param value The principal type used to represent the type of Active Directory Administrator.
     */
    @JvmName("tcvolpjgyahxvbcv")
    public suspend fun principalType(`value`: Output<Either<String, PrincipalType>>) {
        this.principalType = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yyvvstthqxeudlfr")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("dffagkuauabnxbor")
    public suspend fun serverName(`value`: Output<String>) {
        this.serverName = value
    }

    /**
     * @param value The tenantId of the Active Directory administrator.
     */
    @JvmName("gvkvprkdqlpjmhuy")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value Guid of the objectId for the administrator.
     */
    @JvmName("eojvkthmjarxpkei")
    public suspend fun objectId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.objectId = mapped
    }

    /**
     * @param value Active Directory administrator principal name.
     */
    @JvmName("ksehkgacxumrmpvd")
    public suspend fun principalName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalName = mapped
    }

    /**
     * @param value The principal type used to represent the type of Active Directory Administrator.
     */
    @JvmName("qwucokrgiwasvpsd")
    public suspend fun principalType(`value`: Either<String, PrincipalType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The principal type used to represent the type of Active Directory Administrator.
     */
    @JvmName("wbqejmlqvqpvvtkn")
    public fun principalType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The principal type used to represent the type of Active Directory Administrator.
     */
    @JvmName("adjageysqfjboemm")
    public fun principalType(`value`: PrincipalType) {
        val toBeMapped = Either.ofRight<String, PrincipalType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.principalType = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("upwsfdptrddmcldx")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("hmwohmoyashvnwev")
    public suspend fun serverName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverName = mapped
    }

    /**
     * @param value The tenantId of the Active Directory administrator.
     */
    @JvmName("hnvnhaydfiqoqhrb")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AdministratorArgs = AdministratorArgs(
        objectId = objectId,
        principalName = principalName,
        principalType = principalType,
        resourceGroupName = resourceGroupName,
        serverName = serverName,
        tenantId = tenantId,
    )
}
