@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.ActiveDirectoryAuthEnum
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.PasswordAuthEnum
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authentication configuration properties of a server
 * @property activeDirectoryAuth If Enabled, Azure Active Directory authentication is enabled.
 * @property passwordAuth If Enabled, Password authentication is enabled.
 * @property tenantId Tenant id of the server.
 */
public data class AuthConfigArgs(
    public val activeDirectoryAuth: Output<Either<String, ActiveDirectoryAuthEnum>>? = null,
    public val passwordAuth: Output<Either<String, PasswordAuthEnum>>? = null,
    public val tenantId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.AuthConfigArgs.builder()
            .activeDirectoryAuth(
                activeDirectoryAuth?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .passwordAuth(
                passwordAuth?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tenantId(tenantId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AuthConfigArgs].
 */
@PulumiTagMarker
public class AuthConfigArgsBuilder internal constructor() {
    private var activeDirectoryAuth: Output<Either<String, ActiveDirectoryAuthEnum>>? = null

    private var passwordAuth: Output<Either<String, PasswordAuthEnum>>? = null

    private var tenantId: Output<String>? = null

    /**
     * @param value If Enabled, Azure Active Directory authentication is enabled.
     */
    @JvmName("aegxymhouxoqcpxl")
    public suspend fun activeDirectoryAuth(`value`: Output<Either<String, ActiveDirectoryAuthEnum>>) {
        this.activeDirectoryAuth = value
    }

    /**
     * @param value If Enabled, Password authentication is enabled.
     */
    @JvmName("qxoubdevqgikpmpv")
    public suspend fun passwordAuth(`value`: Output<Either<String, PasswordAuthEnum>>) {
        this.passwordAuth = value
    }

    /**
     * @param value Tenant id of the server.
     */
    @JvmName("jwsqxobivdhgjdrc")
    public suspend fun tenantId(`value`: Output<String>) {
        this.tenantId = value
    }

    /**
     * @param value If Enabled, Azure Active Directory authentication is enabled.
     */
    @JvmName("mrgbmbnvbofgvvfd")
    public suspend fun activeDirectoryAuth(`value`: Either<String, ActiveDirectoryAuthEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.activeDirectoryAuth = mapped
    }

    /**
     * @param value If Enabled, Azure Active Directory authentication is enabled.
     */
    @JvmName("bpeiekmsixymxxbb")
    public fun activeDirectoryAuth(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActiveDirectoryAuthEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeDirectoryAuth = mapped
    }

    /**
     * @param value If Enabled, Azure Active Directory authentication is enabled.
     */
    @JvmName("rktwiqjjvmyuyusx")
    public fun activeDirectoryAuth(`value`: ActiveDirectoryAuthEnum) {
        val toBeMapped = Either.ofRight<String, ActiveDirectoryAuthEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.activeDirectoryAuth = mapped
    }

    /**
     * @param value If Enabled, Password authentication is enabled.
     */
    @JvmName("kqqxcxhjolwvswvg")
    public suspend fun passwordAuth(`value`: Either<String, PasswordAuthEnum>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passwordAuth = mapped
    }

    /**
     * @param value If Enabled, Password authentication is enabled.
     */
    @JvmName("hwffqnumrqugxdwc")
    public fun passwordAuth(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PasswordAuthEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwordAuth = mapped
    }

    /**
     * @param value If Enabled, Password authentication is enabled.
     */
    @JvmName("ogfdsbutyxdxudtl")
    public fun passwordAuth(`value`: PasswordAuthEnum) {
        val toBeMapped = Either.ofRight<String, PasswordAuthEnum>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.passwordAuth = mapped
    }

    /**
     * @param value Tenant id of the server.
     */
    @JvmName("mvixaplibthqcuth")
    public suspend fun tenantId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenantId = mapped
    }

    internal fun build(): AuthConfigArgs = AuthConfigArgs(
        activeDirectoryAuth = activeDirectoryAuth,
        passwordAuth = passwordAuth,
        tenantId = tenantId,
    )
}
