@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.GetAdministratorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property objectId Guid of the objectId for the administrator.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serverName The name of the server.
 */
public data class GetAdministratorPlainArgs(
    public val objectId: String,
    public val resourceGroupName: String,
    public val serverName: String,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.GetAdministratorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.GetAdministratorPlainArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.GetAdministratorPlainArgs.builder()
            .objectId(objectId.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serverName(serverName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAdministratorPlainArgs].
 */
@PulumiTagMarker
public class GetAdministratorPlainArgsBuilder internal constructor() {
    private var objectId: String? = null

    private var resourceGroupName: String? = null

    private var serverName: String? = null

    /**
     * @param value Guid of the objectId for the administrator.
     */
    @JvmName("lsqrvtaswfmvkpuw")
    public suspend fun objectId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.objectId = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xtvgfdenwwxdehsp")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the server.
     */
    @JvmName("taschlsjvlvaantq")
    public suspend fun serverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serverName = mapped
    }

    internal fun build(): GetAdministratorPlainArgs = GetAdministratorPlainArgs(
        objectId = objectId ?: throw PulumiNullFieldException("objectId"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serverName = serverName ?: throw PulumiNullFieldException("serverName"),
    )
}
