@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs.builder
import com.pulumi.azurenative.dbforpostgresql.kotlin.enums.HighAvailabilityMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * High availability properties of a server
 * @property mode The HA mode for the server.
 * @property standbyAvailabilityZone availability zone information of the standby.
 */
public data class HighAvailabilityArgs(
    public val mode: Output<Either<String, HighAvailabilityMode>>? = null,
    public val standbyAvailabilityZone: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.HighAvailabilityArgs.builder()
            .mode(
                mode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .standbyAvailabilityZone(standbyAvailabilityZone?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HighAvailabilityArgs].
 */
@PulumiTagMarker
public class HighAvailabilityArgsBuilder internal constructor() {
    private var mode: Output<Either<String, HighAvailabilityMode>>? = null

    private var standbyAvailabilityZone: Output<String>? = null

    /**
     * @param value The HA mode for the server.
     */
    @JvmName("tybdywfjeaddpcfr")
    public suspend fun mode(`value`: Output<Either<String, HighAvailabilityMode>>) {
        this.mode = value
    }

    /**
     * @param value availability zone information of the standby.
     */
    @JvmName("nckcecdujduyemxw")
    public suspend fun standbyAvailabilityZone(`value`: Output<String>) {
        this.standbyAvailabilityZone = value
    }

    /**
     * @param value The HA mode for the server.
     */
    @JvmName("botjnwjcbgnsitcd")
    public suspend fun mode(`value`: Either<String, HighAvailabilityMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The HA mode for the server.
     */
    @JvmName("xxydorwjtusbynfl")
    public fun mode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HighAvailabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The HA mode for the server.
     */
    @JvmName("ixqsbvpinjucklib")
    public fun mode(`value`: HighAvailabilityMode) {
        val toBeMapped = Either.ofRight<String, HighAvailabilityMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value availability zone information of the standby.
     */
    @JvmName("npojkvhuoqwuyegy")
    public suspend fun standbyAvailabilityZone(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.standbyAvailabilityZone = mapped
    }

    internal fun build(): HighAvailabilityArgs = HighAvailabilityArgs(
        mode = mode,
        standbyAvailabilityZone = standbyAvailabilityZone,
    )
}
