@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Network properties of a server.
 * @property delegatedSubnetResourceId Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
 * @property privateDnsZoneArmResourceId Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
 */
public data class NetworkArgs(
    public val delegatedSubnetResourceId: Output<String>? = null,
    public val privateDnsZoneArmResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.NetworkArgs.builder()
            .delegatedSubnetResourceId(delegatedSubnetResourceId?.applyValue({ args0 -> args0 }))
            .privateDnsZoneArmResourceId(privateDnsZoneArmResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NetworkArgs].
 */
@PulumiTagMarker
public class NetworkArgsBuilder internal constructor() {
    private var delegatedSubnetResourceId: Output<String>? = null

    private var privateDnsZoneArmResourceId: Output<String>? = null

    /**
     * @param value Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
     */
    @JvmName("kwrgecjwmuatunbj")
    public suspend fun delegatedSubnetResourceId(`value`: Output<String>) {
        this.delegatedSubnetResourceId = value
    }

    /**
     * @param value Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
     */
    @JvmName("ahffxagsplrctsaf")
    public suspend fun privateDnsZoneArmResourceId(`value`: Output<String>) {
        this.privateDnsZoneArmResourceId = value
    }

    /**
     * @param value Delegated subnet arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
     */
    @JvmName("pylwfkwsyhtfgheo")
    public suspend fun delegatedSubnetResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.delegatedSubnetResourceId = mapped
    }

    /**
     * @param value Private dns zone arm resource id. This is required to be passed during create, in case we want the server to be VNET injected, i.e. Private access server. During update, pass this only if we want to update the value for Private DNS zone.
     */
    @JvmName("lqfbbeanasxielfr")
    public suspend fun privateDnsZoneArmResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateDnsZoneArmResourceId = mapped
    }

    internal fun build(): NetworkArgs = NetworkArgs(
        delegatedSubnetResourceId = delegatedSubnetResourceId,
        privateDnsZoneArmResourceId = privateDnsZoneArmResourceId,
    )
}
