@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Storage properties of a server
 * @property storageSizeGB Max storage allowed for a server.
 */
public data class StorageArgs(
    public val storageSizeGB: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.StorageArgs.builder()
            .storageSizeGB(storageSizeGB?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StorageArgs].
 */
@PulumiTagMarker
public class StorageArgsBuilder internal constructor() {
    private var storageSizeGB: Output<Int>? = null

    /**
     * @param value Max storage allowed for a server.
     */
    @JvmName("nmgcrgqhltosbuem")
    public suspend fun storageSizeGB(`value`: Output<Int>) {
        this.storageSizeGB = value
    }

    /**
     * @param value Max storage allowed for a server.
     */
    @JvmName("egbnjlidqfvobpdu")
    public suspend fun storageSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageSizeGB = mapped
    }

    internal fun build(): StorageArgs = StorageArgs(
        storageSizeGB = storageSizeGB,
    )
}
