@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.inputs

import com.pulumi.azurenative.dbforpostgresql.inputs.UserIdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a single user-assigned identity associated with the application.
 * @property clientId the client identifier of the Service Principal which this identity represents.
 * @property principalId the object identifier of the Service Principal which this identity represents.
 */
public data class UserIdentityArgs(
    public val clientId: Output<String>? = null,
    public val principalId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.dbforpostgresql.inputs.UserIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.dbforpostgresql.inputs.UserIdentityArgs =
        com.pulumi.azurenative.dbforpostgresql.inputs.UserIdentityArgs.builder()
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .principalId(principalId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserIdentityArgs].
 */
@PulumiTagMarker
public class UserIdentityArgsBuilder internal constructor() {
    private var clientId: Output<String>? = null

    private var principalId: Output<String>? = null

    /**
     * @param value the client identifier of the Service Principal which this identity represents.
     */
    @JvmName("noexrhvogqheuhft")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value the object identifier of the Service Principal which this identity represents.
     */
    @JvmName("mkjhjmydlclviyin")
    public suspend fun principalId(`value`: Output<String>) {
        this.principalId = value
    }

    /**
     * @param value the client identifier of the Service Principal which this identity represents.
     */
    @JvmName("iejruhjikflopgfa")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value the object identifier of the Service Principal which this identity represents.
     */
    @JvmName("jdfxhvajsltnnuyn")
    public suspend fun principalId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalId = mapped
    }

    internal fun build(): UserIdentityArgs = UserIdentityArgs(
        clientId = clientId,
        principalId = principalId,
    )
}
