@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Authentication configuration properties of a server
 * @property activeDirectoryAuth If Enabled, Azure Active Directory authentication is enabled.
 * @property passwordAuth If Enabled, Password authentication is enabled.
 * @property tenantId Tenant id of the server.
 */
public data class AuthConfigResponse(
    public val activeDirectoryAuth: String? = null,
    public val passwordAuth: String? = null,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.AuthConfigResponse):
            AuthConfigResponse = AuthConfigResponse(
            activeDirectoryAuth = javaType.activeDirectoryAuth().map({ args0 -> args0 }).orElse(null),
            passwordAuth = javaType.passwordAuth().map({ args0 -> args0 }).orElse(null),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
