@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.dbforpostgresql.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Database server metadata.
 * @property location Location of database server
 * @property sku SKU for the database server
 * @property storageMb Storage size in MB for database server
 * @property version Version for database engine
 */
public data class DbServerMetadataResponse(
    public val location: String,
    public val sku: ServerSkuResponse? = null,
    public val storageMb: Int? = null,
    public val version: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.dbforpostgresql.outputs.DbServerMetadataResponse):
            DbServerMetadataResponse = DbServerMetadataResponse(
            location = javaType.location(),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.dbforpostgresql.kotlin.outputs.ServerSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            storageMb = javaType.storageMb().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
