@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.SasAuthenticationResponse
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.SasAuthenticationResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ArtifactSource].
 */
@PulumiTagMarker
public class ArtifactSourceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ArtifactSourceArgs = ArtifactSourceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ArtifactSourceArgsBuilder.() -> Unit) {
        val builder = ArtifactSourceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ArtifactSource {
        val builtJavaResource =
            com.pulumi.azurenative.deploymentmanager.ArtifactSource(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ArtifactSource(builtJavaResource)
    }
}

/**
 * The resource that defines the source location where the artifacts are located.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create artifact source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DeploymentManager.ArtifactSource("artifactSource", new()
 *     {
 *         ArtifactSourceName = "myArtifactSource",
 *         Authentication = new AzureNative.DeploymentManager.Inputs.SasAuthenticationArgs
 *         {
 *             SasUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             Type = "Sas",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceType = "AzureStorage",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := deploymentmanager.NewArtifactSource(ctx, "artifactSource", &deploymentmanager.ArtifactSourceArgs{
 * ArtifactSourceName: pulumi.String("myArtifactSource"),
 * Authentication: interface{}{
 * SasUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * Type: pulumi.String("Sas"),
 * },
 * Location: pulumi.String("centralus"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SourceType: pulumi.String("AzureStorage"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSource;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .artifactSourceName("myArtifactSource")
 *             .authentication(Map.ofEntries(
 *                 Map.entry("sasUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("type", "Sas")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceType("AzureStorage")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create artifact source with artifact root, an offset into the storage container
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DeploymentManager.ArtifactSource("artifactSource", new()
 *     {
 *         ArtifactRoot = "1.0.0.0",
 *         ArtifactSourceName = "myArtifactSource",
 *         Authentication = new AzureNative.DeploymentManager.Inputs.SasAuthenticationArgs
 *         {
 *             SasUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             Type = "Sas",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceType = "AzureStorage",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := deploymentmanager.NewArtifactSource(ctx, "artifactSource", &deploymentmanager.ArtifactSourceArgs{
 * ArtifactRoot: pulumi.String("1.0.0.0"),
 * ArtifactSourceName: pulumi.String("myArtifactSource"),
 * Authentication: interface{}{
 * SasUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * Type: pulumi.String("Sas"),
 * },
 * Location: pulumi.String("centralus"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SourceType: pulumi.String("AzureStorage"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSource;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .artifactRoot("1.0.0.0")
 *             .artifactSourceName("myArtifactSource")
 *             .authentication(Map.ofEntries(
 *                 Map.entry("sasUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("type", "Sas")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceType("AzureStorage")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ArtifactSource myArtifactSource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/artifactSources/{artifactSourceName}
 * ```
 */
public class ArtifactSource internal constructor(
    override val javaResource: com.pulumi.azurenative.deploymentmanager.ArtifactSource,
) : KotlinCustomResource(javaResource, ArtifactSourceMapper) {
    /**
     * The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to differentiate different versions of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication property concatenated with this optional artifactRoot path forms the artifact source location where the artifacts are expected to be found.
     */
    public val artifactRoot: Output<String>?
        get() = javaResource.artifactRoot().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The authentication method to use to access the artifact source.
     */
    public val authentication: Output<SasAuthenticationResponse>
        get() = javaResource.authentication().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The type of artifact source used.
     */
    public val sourceType: Output<String>
        get() = javaResource.sourceType().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ArtifactSourceMapper : ResourceMapper<ArtifactSource> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deploymentmanager.ArtifactSource::class == javaResource::class

    override fun map(javaResource: Resource): ArtifactSource = ArtifactSource(
        javaResource as
            com.pulumi.azurenative.deploymentmanager.ArtifactSource,
    )
}

/**
 * @see [ArtifactSource].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ArtifactSource].
 */
public suspend fun artifactSource(
    name: String,
    block: suspend ArtifactSourceResourceBuilder.() -> Unit,
): ArtifactSource {
    val builder = ArtifactSourceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ArtifactSource].
 * @param name The _unique_ name of the resulting resource.
 */
public fun artifactSource(name: String): ArtifactSource {
    val builder = ArtifactSourceResourceBuilder()
    builder.name(name)
    return builder.build()
}
