@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.SasAuthenticationArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.SasAuthenticationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource that defines the source location where the artifacts are located.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create artifact source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DeploymentManager.ArtifactSource("artifactSource", new()
 *     {
 *         ArtifactSourceName = "myArtifactSource",
 *         Authentication = new AzureNative.DeploymentManager.Inputs.SasAuthenticationArgs
 *         {
 *             SasUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             Type = "Sas",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceType = "AzureStorage",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := deploymentmanager.NewArtifactSource(ctx, "artifactSource", &deploymentmanager.ArtifactSourceArgs{
 * ArtifactSourceName: pulumi.String("myArtifactSource"),
 * Authentication: interface{}{
 * SasUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * Type: pulumi.String("Sas"),
 * },
 * Location: pulumi.String("centralus"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SourceType: pulumi.String("AzureStorage"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSource;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .artifactSourceName("myArtifactSource")
 *             .authentication(Map.ofEntries(
 *                 Map.entry("sasUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("type", "Sas")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceType("AzureStorage")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create artifact source with artifact root, an offset into the storage container
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var artifactSource = new AzureNative.DeploymentManager.ArtifactSource("artifactSource", new()
 *     {
 *         ArtifactRoot = "1.0.0.0",
 *         ArtifactSourceName = "myArtifactSource",
 *         Authentication = new AzureNative.DeploymentManager.Inputs.SasAuthenticationArgs
 *         {
 *             SasUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             Type = "Sas",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         SourceType = "AzureStorage",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := deploymentmanager.NewArtifactSource(ctx, "artifactSource", &deploymentmanager.ArtifactSourceArgs{
 * ArtifactRoot: pulumi.String("1.0.0.0"),
 * ArtifactSourceName: pulumi.String("myArtifactSource"),
 * Authentication: interface{}{
 * SasUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * Type: pulumi.String("Sas"),
 * },
 * Location: pulumi.String("centralus"),
 * ResourceGroupName: pulumi.String("myResourceGroup"),
 * SourceType: pulumi.String("AzureStorage"),
 * Tags: nil,
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSource;
 * import com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var artifactSource = new ArtifactSource("artifactSource", ArtifactSourceArgs.builder()
 *             .artifactRoot("1.0.0.0")
 *             .artifactSourceName("myArtifactSource")
 *             .authentication(Map.ofEntries(
 *                 Map.entry("sasUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("type", "Sas")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .sourceType("AzureStorage")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ArtifactSource myArtifactSource /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/artifactSources/{artifactSourceName}
 * ```
 * @property artifactRoot The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to differentiate different versions of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication property concatenated with this optional artifactRoot path forms the artifact source location where the artifacts are expected to be found.
 * @property artifactSourceName The name of the artifact source.
 * @property authentication The authentication method to use to access the artifact source.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sourceType The type of artifact source used.
 * @property tags Resource tags.
 */
public data class ArtifactSourceArgs(
    public val artifactRoot: Output<String>? = null,
    public val artifactSourceName: Output<String>? = null,
    public val authentication: Output<SasAuthenticationArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs =
        com.pulumi.azurenative.deploymentmanager.ArtifactSourceArgs.builder()
            .artifactRoot(artifactRoot?.applyValue({ args0 -> args0 }))
            .artifactSourceName(artifactSourceName?.applyValue({ args0 -> args0 }))
            .authentication(authentication?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceType(sourceType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ArtifactSourceArgs].
 */
@PulumiTagMarker
public class ArtifactSourceArgsBuilder internal constructor() {
    private var artifactRoot: Output<String>? = null

    private var artifactSourceName: Output<String>? = null

    private var authentication: Output<SasAuthenticationArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to differentiate different versions of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication property concatenated with this optional artifactRoot path forms the artifact source location where the artifacts are expected to be found.
     */
    @JvmName("dqcnqwiiqxgmwivf")
    public suspend fun artifactRoot(`value`: Output<String>) {
        this.artifactRoot = value
    }

    /**
     * @param value The name of the artifact source.
     */
    @JvmName("dagfdyqqkvjjuwea")
    public suspend fun artifactSourceName(`value`: Output<String>) {
        this.artifactSourceName = value
    }

    /**
     * @param value The authentication method to use to access the artifact source.
     */
    @JvmName("jmdhlbgewamhyrik")
    public suspend fun authentication(`value`: Output<SasAuthenticationArgs>) {
        this.authentication = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("fidhtobmrsvlygpq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("emvwtkedtkbhlfja")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The type of artifact source used.
     */
    @JvmName("onghiapaebqhvyiu")
    public suspend fun sourceType(`value`: Output<String>) {
        this.sourceType = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("kjxfyadgpghfxord")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The path from the location that the 'authentication' property [say, a SAS URI to the blob container] refers to, to the location of the artifacts. This can be used to differentiate different versions of the artifacts. Or, different types of artifacts like binaries or templates. The location referenced by the authentication property concatenated with this optional artifactRoot path forms the artifact source location where the artifacts are expected to be found.
     */
    @JvmName("gmnykfnfmwuceeiy")
    public suspend fun artifactRoot(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactRoot = mapped
    }

    /**
     * @param value The name of the artifact source.
     */
    @JvmName("rgnjelpjittnsolt")
    public suspend fun artifactSourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactSourceName = mapped
    }

    /**
     * @param value The authentication method to use to access the artifact source.
     */
    @JvmName("wtuvajlfxnvhnccl")
    public suspend fun authentication(`value`: SasAuthenticationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param argument The authentication method to use to access the artifact source.
     */
    @JvmName("yljrkohmyqyuvrrm")
    public suspend fun authentication(argument: suspend SasAuthenticationArgsBuilder.() -> Unit) {
        val toBeMapped = SasAuthenticationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.authentication = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ofohaxpnxrpihphx")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("udosiqheuhpddpgm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The type of artifact source used.
     */
    @JvmName("orqchiqkucdbncrg")
    public suspend fun sourceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceType = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("eymerprceclxwajr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("eqecroegafkdqffc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ArtifactSourceArgs = ArtifactSourceArgs(
        artifactRoot = artifactRoot,
        artifactSourceName = artifactSourceName,
        authentication = authentication,
        location = location,
        resourceGroupName = resourceGroupName,
        sourceType = sourceType,
        tags = tags,
    )
}
