@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getArtifactSourcePlain
import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getRolloutPlain
import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getServicePlain
import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getServiceTopologyPlain
import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getServiceUnitPlain
import com.pulumi.azurenative.deploymentmanager.DeploymentmanagerFunctions.getStepPlain
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetArtifactSourcePlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetArtifactSourcePlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetRolloutPlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetRolloutPlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServicePlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServicePlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServiceTopologyPlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServiceTopologyPlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServiceUnitPlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetServiceUnitPlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetStepPlainArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.GetStepPlainArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetArtifactSourceResult
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetRolloutResult
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceResult
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceTopologyResult
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceUnitResult
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetStepResult
import kotlinx.coroutines.future.await
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetArtifactSourceResult.Companion.toKotlin as getArtifactSourceResultToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetRolloutResult.Companion.toKotlin as getRolloutResultToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceResult.Companion.toKotlin as getServiceResultToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceTopologyResult.Companion.toKotlin as getServiceTopologyResultToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetServiceUnitResult.Companion.toKotlin as getServiceUnitResultToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.GetStepResult.Companion.toKotlin as getStepResultToKotlin

public object DeploymentmanagerFunctions {
    /**
     * The resource that defines the source location where the artifacts are located.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return The resource that defines the source location where the artifacts are located.
     */
    public suspend fun getArtifactSource(argument: GetArtifactSourcePlainArgs):
        GetArtifactSourceResult =
        getArtifactSourceResultToKotlin(getArtifactSourcePlain(argument.toJava()).await())

    /**
     * @see [getArtifactSource].
     * @param artifactSourceName The name of the artifact source.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The resource that defines the source location where the artifacts are located.
     */
    public suspend fun getArtifactSource(artifactSourceName: String, resourceGroupName: String):
        GetArtifactSourceResult {
        val argument = GetArtifactSourcePlainArgs(
            artifactSourceName = artifactSourceName,
            resourceGroupName = resourceGroupName,
        )
        return getArtifactSourceResultToKotlin(getArtifactSourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getArtifactSource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetArtifactSourcePlainArgs].
     * @return The resource that defines the source location where the artifacts are located.
     */
    public suspend
    fun getArtifactSource(argument: suspend GetArtifactSourcePlainArgsBuilder.() -> Unit):
        GetArtifactSourceResult {
        val builder = GetArtifactSourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getArtifactSourceResultToKotlin(getArtifactSourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Defines the PUT rollout request body.
     * Azure REST API version: 2019-11-01-preview.
     * Other available API versions: 2018-09-01-preview.
     * @param argument null
     * @return Defines the rollout.
     */
    public suspend fun getRollout(argument: GetRolloutPlainArgs): GetRolloutResult =
        getRolloutResultToKotlin(getRolloutPlain(argument.toJava()).await())

    /**
     * @see [getRollout].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param retryAttempt Rollout retry attempt ordinal to get the result of. If not specified, result of the latest attempt will be returned.
     * @param rolloutName The rollout name.
     * @return Defines the rollout.
     */
    public suspend fun getRollout(
        resourceGroupName: String,
        retryAttempt: Int? = null,
        rolloutName: String,
    ): GetRolloutResult {
        val argument = GetRolloutPlainArgs(
            resourceGroupName = resourceGroupName,
            retryAttempt = retryAttempt,
            rolloutName = rolloutName,
        )
        return getRolloutResultToKotlin(getRolloutPlain(argument.toJava()).await())
    }

    /**
     * @see [getRollout].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetRolloutPlainArgs].
     * @return Defines the rollout.
     */
    public suspend fun getRollout(argument: suspend GetRolloutPlainArgsBuilder.() -> Unit):
        GetRolloutResult {
        val builder = GetRolloutPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getRolloutResultToKotlin(getRolloutPlain(builtArgument.toJava()).await())
    }

    /**
     * The resource representation of a service in a service topology.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return The resource representation of a service in a service topology.
     */
    public suspend fun getService(argument: GetServicePlainArgs): GetServiceResult =
        getServiceResultToKotlin(getServicePlain(argument.toJava()).await())

    /**
     * @see [getService].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the service resource.
     * @param serviceTopologyName The name of the service topology .
     * @return The resource representation of a service in a service topology.
     */
    public suspend fun getService(
        resourceGroupName: String,
        serviceName: String,
        serviceTopologyName: String,
    ): GetServiceResult {
        val argument = GetServicePlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            serviceTopologyName = serviceTopologyName,
        )
        return getServiceResultToKotlin(getServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetServicePlainArgs].
     * @return The resource representation of a service in a service topology.
     */
    public suspend fun getService(argument: suspend GetServicePlainArgsBuilder.() -> Unit):
        GetServiceResult {
        val builder = GetServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceResultToKotlin(getServicePlain(builtArgument.toJava()).await())
    }

    /**
     * The resource representation of a service topology.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return The resource representation of a service topology.
     */
    public suspend fun getServiceTopology(argument: GetServiceTopologyPlainArgs):
        GetServiceTopologyResult =
        getServiceTopologyResultToKotlin(getServiceTopologyPlain(argument.toJava()).await())

    /**
     * @see [getServiceTopology].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceTopologyName The name of the service topology .
     * @return The resource representation of a service topology.
     */
    public suspend fun getServiceTopology(resourceGroupName: String, serviceTopologyName: String):
        GetServiceTopologyResult {
        val argument = GetServiceTopologyPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceTopologyName = serviceTopologyName,
        )
        return getServiceTopologyResultToKotlin(getServiceTopologyPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceTopology].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetServiceTopologyPlainArgs].
     * @return The resource representation of a service topology.
     */
    public suspend
    fun getServiceTopology(argument: suspend GetServiceTopologyPlainArgsBuilder.() -> Unit):
        GetServiceTopologyResult {
        val builder = GetServiceTopologyPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceTopologyResultToKotlin(getServiceTopologyPlain(builtArgument.toJava()).await())
    }

    /**
     * Represents the response of a service unit resource.
     * Azure REST API version: 2019-11-01-preview.
     * @param argument null
     * @return Represents the response of a service unit resource.
     */
    public suspend fun getServiceUnit(argument: GetServiceUnitPlainArgs): GetServiceUnitResult =
        getServiceUnitResultToKotlin(getServiceUnitPlain(argument.toJava()).await())

    /**
     * @see [getServiceUnit].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the service resource.
     * @param serviceTopologyName The name of the service topology .
     * @param serviceUnitName The name of the service unit resource.
     * @return Represents the response of a service unit resource.
     */
    public suspend fun getServiceUnit(
        resourceGroupName: String,
        serviceName: String,
        serviceTopologyName: String,
        serviceUnitName: String,
    ): GetServiceUnitResult {
        val argument = GetServiceUnitPlainArgs(
            resourceGroupName = resourceGroupName,
            serviceName = serviceName,
            serviceTopologyName = serviceTopologyName,
            serviceUnitName = serviceUnitName,
        )
        return getServiceUnitResultToKotlin(getServiceUnitPlain(argument.toJava()).await())
    }

    /**
     * @see [getServiceUnit].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetServiceUnitPlainArgs].
     * @return Represents the response of a service unit resource.
     */
    public suspend fun getServiceUnit(argument: suspend GetServiceUnitPlainArgsBuilder.() -> Unit):
        GetServiceUnitResult {
        val builder = GetServiceUnitPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getServiceUnitResultToKotlin(getServiceUnitPlain(builtArgument.toJava()).await())
    }

    /**
     * The resource representation of a rollout step.
     * Azure REST API version: 2019-11-01-preview.
     * Other available API versions: 2018-09-01-preview.
     * @param argument null
     * @return The resource representation of a rollout step.
     */
    public suspend fun getStep(argument: GetStepPlainArgs): GetStepResult =
        getStepResultToKotlin(getStepPlain(argument.toJava()).await())

    /**
     * @see [getStep].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param stepName The name of the deployment step.
     * @return The resource representation of a rollout step.
     */
    public suspend fun getStep(resourceGroupName: String, stepName: String): GetStepResult {
        val argument = GetStepPlainArgs(
            resourceGroupName = resourceGroupName,
            stepName = stepName,
        )
        return getStepResultToKotlin(getStepPlain(argument.toJava()).await())
    }

    /**
     * @see [getStep].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;deploymentmanager&#46;kotlin&#46;inputs&#46;GetStepPlainArgs].
     * @return The resource representation of a rollout step.
     */
    public suspend fun getStep(argument: suspend GetStepPlainArgsBuilder.() -> Unit): GetStepResult {
        val builder = GetStepPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getStepResultToKotlin(getStepPlain(builtArgument.toJava()).await())
    }
}
