@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.StepGroupResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.StepGroupResponse.Companion.toKotlin as stepGroupResponseToKotlin

/**
 * Builder for [Rollout].
 */
@PulumiTagMarker
public class RolloutResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RolloutArgs = RolloutArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RolloutArgsBuilder.() -> Unit) {
        val builder = RolloutArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Rollout {
        val builtJavaResource =
            com.pulumi.azurenative.deploymentmanager.Rollout(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Rollout(builtJavaResource)
    }
}

/**
 * Defines the PUT rollout request body.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update rollout
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rollout = new AzureNative.DeploymentManager.Rollout("rollout", new()
 *     {
 *         ArtifactSourceId = "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource",
 *         BuildVersion = "1.0.0.1",
 *         Identity = new AzureNative.DeploymentManager.Inputs.IdentityArgs
 *         {
 *             IdentityIds = new[]
 *             {
 *                 "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity",
 *             },
 *             Type = "userAssigned",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         RolloutName = "myRollout",
 *         StepGroups = new[]
 *         {
 *             new AzureNative.DeploymentManager.Inputs.StepGroupArgs
 *             {
 *                 DeploymentTargetId = "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'",
 *                 Name = "FirstRegion",
 *                 PostDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/postDeployStep1",
 *                     },
 *                 },
 *                 PreDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep1",
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep2",
 *                     },
 *                 },
 *             },
 *             new AzureNative.DeploymentManager.Inputs.StepGroupArgs
 *             {
 *                 DependsOnStepGroups = new[]
 *                 {
 *                     "FirstRegion",
 *                 },
 *                 DeploymentTargetId = "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'",
 *                 Name = "SecondRegion",
 *                 PostDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/postDeployStep5",
 *                     },
 *                 },
 *                 PreDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep3",
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep4",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *         TargetServiceTopologyId = "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewRollout(ctx, "rollout", &deploymentmanager.RolloutArgs{
 * 			ArtifactSourceId: pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource"),
 * 			BuildVersion:     pulumi.String("1.0.0.1"),
 * 			Identity: &deploymentmanager.IdentityArgs{
 * 				IdentityIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity"),
 * 				},
 * 				Type: pulumi.String("userAssigned"),
 * 			},
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RolloutName:       pulumi.String("myRollout"),
 * 			StepGroups: []deploymentmanager.StepGroupArgs{
 * 				{
 * 					DeploymentTargetId: pulumi.String("Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'"),
 * 					Name:               pulumi.String("FirstRegion"),
 * 					PostDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/postDeployStep1"),
 * 						},
 * 					},
 * 					PreDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep1"),
 * 						},
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep2"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					DependsOnStepGroups: pulumi.StringArray{
 * 						pulumi.String("FirstRegion"),
 * 					},
 * 					DeploymentTargetId: pulumi.String("Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'"),
 * 					Name:               pulumi.String("SecondRegion"),
 * 					PostDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/postDeployStep5"),
 * 						},
 * 					},
 * 					PreDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep3"),
 * 						},
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep4"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags:                    nil,
 * 			TargetServiceTopologyId: pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Rollout;
 * import com.pulumi.azurenative.deploymentmanager.RolloutArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rollout = new Rollout("rollout", RolloutArgs.builder()
 *             .artifactSourceId("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource")
 *             .buildVersion("1.0.0.1")
 *             .identity(Map.ofEntries(
 *                 Map.entry("identityIds", "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity"),
 *                 Map.entry("type", "userAssigned")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .rolloutName("myRollout")
 *             .stepGroups(
 *                 Map.ofEntries(
 *                     Map.entry("deploymentTargetId", "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'"),
 *                     Map.entry("name", "FirstRegion"),
 *                     Map.entry("postDeploymentSteps", Map.of("stepId", "Microsoft.DeploymentManager/steps/postDeployStep1")),
 *                     Map.entry("preDeploymentSteps",
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep1"),
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep2"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("dependsOnStepGroups", "FirstRegion"),
 *                     Map.entry("deploymentTargetId", "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'"),
 *                     Map.entry("name", "SecondRegion"),
 *                     Map.entry("postDeploymentSteps", Map.of("stepId", "Microsoft.DeploymentManager/steps/postDeployStep5")),
 *                     Map.entry("preDeploymentSteps",
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep3"),
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep4"))
 *                 ))
 *             .tags()
 *             .targetServiceTopologyId("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:Rollout myRollout /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/rollouts/{rolloutName}
 * ```
 */
public class Rollout internal constructor(
    override val javaResource: com.pulumi.azurenative.deploymentmanager.Rollout,
) : KotlinCustomResource(javaResource, RolloutMapper) {
    /**
     * The reference to the artifact source resource Id where the payload is located.
     */
    public val artifactSourceId: Output<String>?
        get() = javaResource.artifactSourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The version of the build being deployed.
     */
    public val buildVersion: Output<String>
        get() = javaResource.buildVersion().applyValue({ args0 -> args0 })

    /**
     * Identity for the resource.
     */
    public val identity: Output<IdentityResponse>
        get() = javaResource.identity().applyValue({ args0 ->
            args0.let({ args0 ->
                identityResponseToKotlin(args0)
            })
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The list of step groups that define the orchestration.
     */
    public val stepGroups: Output<List<StepGroupResponse>>
        get() = javaResource.stepGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    stepGroupResponseToKotlin(args0)
                })
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
     */
    public val targetServiceTopologyId: Output<String>
        get() = javaResource.targetServiceTopologyId().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RolloutMapper : ResourceMapper<Rollout> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deploymentmanager.Rollout::class == javaResource::class

    override fun map(javaResource: Resource): Rollout = Rollout(
        javaResource as
            com.pulumi.azurenative.deploymentmanager.Rollout,
    )
}

/**
 * @see [Rollout].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rollout].
 */
public suspend fun rollout(name: String, block: suspend RolloutResourceBuilder.() -> Unit):
    Rollout {
    val builder = RolloutResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rollout].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rollout(name: String): Rollout {
    val builder = RolloutResourceBuilder()
    builder.name(name)
    return builder.build()
}
