@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.RolloutArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.StepGroupArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.StepGroupArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Defines the PUT rollout request body.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create or update rollout
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rollout = new AzureNative.DeploymentManager.Rollout("rollout", new()
 *     {
 *         ArtifactSourceId = "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource",
 *         BuildVersion = "1.0.0.1",
 *         Identity = new AzureNative.DeploymentManager.Inputs.IdentityArgs
 *         {
 *             IdentityIds = new[]
 *             {
 *                 "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity",
 *             },
 *             Type = "userAssigned",
 *         },
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         RolloutName = "myRollout",
 *         StepGroups = new[]
 *         {
 *             new AzureNative.DeploymentManager.Inputs.StepGroupArgs
 *             {
 *                 DeploymentTargetId = "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'",
 *                 Name = "FirstRegion",
 *                 PostDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/postDeployStep1",
 *                     },
 *                 },
 *                 PreDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep1",
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep2",
 *                     },
 *                 },
 *             },
 *             new AzureNative.DeploymentManager.Inputs.StepGroupArgs
 *             {
 *                 DependsOnStepGroups = new[]
 *                 {
 *                     "FirstRegion",
 *                 },
 *                 DeploymentTargetId = "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'",
 *                 Name = "SecondRegion",
 *                 PostDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/postDeployStep5",
 *                     },
 *                 },
 *                 PreDeploymentSteps = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep3",
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.PrePostStepArgs
 *                     {
 *                         StepId = "Microsoft.DeploymentManager/steps/preDeployStep4",
 *                     },
 *                 },
 *             },
 *         },
 *         Tags = null,
 *         TargetServiceTopologyId = "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewRollout(ctx, "rollout", &deploymentmanager.RolloutArgs{
 * 			ArtifactSourceId: pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource"),
 * 			BuildVersion:     pulumi.String("1.0.0.1"),
 * 			Identity: &deploymentmanager.IdentityArgs{
 * 				IdentityIds: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity"),
 * 				},
 * 				Type: pulumi.String("userAssigned"),
 * 			},
 * 			Location:          pulumi.String("centralus"),
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			RolloutName:       pulumi.String("myRollout"),
 * 			StepGroups: []deploymentmanager.StepGroupArgs{
 * 				{
 * 					DeploymentTargetId: pulumi.String("Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'"),
 * 					Name:               pulumi.String("FirstRegion"),
 * 					PostDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/postDeployStep1"),
 * 						},
 * 					},
 * 					PreDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep1"),
 * 						},
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep2"),
 * 						},
 * 					},
 * 				},
 * 				{
 * 					DependsOnStepGroups: pulumi.StringArray{
 * 						pulumi.String("FirstRegion"),
 * 					},
 * 					DeploymentTargetId: pulumi.String("Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'"),
 * 					Name:               pulumi.String("SecondRegion"),
 * 					PostDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/postDeployStep5"),
 * 						},
 * 					},
 * 					PreDeploymentSteps: deploymentmanager.PrePostStepArray{
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep3"),
 * 						},
 * 						{
 * 							StepId: pulumi.String("Microsoft.DeploymentManager/steps/preDeployStep4"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			Tags:                    nil,
 * 			TargetServiceTopologyId: pulumi.String("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Rollout;
 * import com.pulumi.azurenative.deploymentmanager.RolloutArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rollout = new Rollout("rollout", RolloutArgs.builder()
 *             .artifactSourceId("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/artifactSources/myArtifactSource")
 *             .buildVersion("1.0.0.1")
 *             .identity(Map.ofEntries(
 *                 Map.entry("identityIds", "/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/providers/Microsoft.ManagedIdentity/userassignedidentities/myuseridentity"),
 *                 Map.entry("type", "userAssigned")
 *             ))
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .rolloutName("myRollout")
 *             .stepGroups(
 *                 Map.ofEntries(
 *                     Map.entry("deploymentTargetId", "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit1'"),
 *                     Map.entry("name", "FirstRegion"),
 *                     Map.entry("postDeploymentSteps", Map.of("stepId", "Microsoft.DeploymentManager/steps/postDeployStep1")),
 *                     Map.entry("preDeploymentSteps",
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep1"),
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep2"))
 *                 ),
 *                 Map.ofEntries(
 *                     Map.entry("dependsOnStepGroups", "FirstRegion"),
 *                     Map.entry("deploymentTargetId", "Microsoft.DeploymentManager/serviceTopologies/myTopology/services/myService/serviceUnits/myServiceUnit2'"),
 *                     Map.entry("name", "SecondRegion"),
 *                     Map.entry("postDeploymentSteps", Map.of("stepId", "Microsoft.DeploymentManager/steps/postDeployStep5")),
 *                     Map.entry("preDeploymentSteps",
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep3"),
 *                         Map.of("stepId", "Microsoft.DeploymentManager/steps/preDeployStep4"))
 *                 ))
 *             .tags()
 *             .targetServiceTopologyId("/subscriptions/caac1590-e859-444f-a9e0-62091c0f5929/resourceGroups/myResourceGroup/Microsoft.DeploymentManager/serviceTopologies/myTopology")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:Rollout myRollout /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/rollouts/{rolloutName}
 * ```
 * @property artifactSourceId The reference to the artifact source resource Id where the payload is located.
 * @property buildVersion The version of the build being deployed.
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property rolloutName The rollout name.
 * @property stepGroups The list of step groups that define the orchestration.
 * @property tags Resource tags.
 * @property targetServiceTopologyId The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
 */
public data class RolloutArgs(
    public val artifactSourceId: Output<String>? = null,
    public val buildVersion: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val rolloutName: Output<String>? = null,
    public val stepGroups: Output<List<StepGroupArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetServiceTopologyId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.RolloutArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.RolloutArgs =
        com.pulumi.azurenative.deploymentmanager.RolloutArgs.builder()
            .artifactSourceId(artifactSourceId?.applyValue({ args0 -> args0 }))
            .buildVersion(buildVersion?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .rolloutName(rolloutName?.applyValue({ args0 -> args0 }))
            .stepGroups(
                stepGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetServiceTopologyId(targetServiceTopologyId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RolloutArgs].
 */
@PulumiTagMarker
public class RolloutArgsBuilder internal constructor() {
    private var artifactSourceId: Output<String>? = null

    private var buildVersion: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var rolloutName: Output<String>? = null

    private var stepGroups: Output<List<StepGroupArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetServiceTopologyId: Output<String>? = null

    /**
     * @param value The reference to the artifact source resource Id where the payload is located.
     */
    @JvmName("haaswpmwcrfqkjxv")
    public suspend fun artifactSourceId(`value`: Output<String>) {
        this.artifactSourceId = value
    }

    /**
     * @param value The version of the build being deployed.
     */
    @JvmName("xjpkdqwvoakqipam")
    public suspend fun buildVersion(`value`: Output<String>) {
        this.buildVersion = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("aencgsvftqaupmpi")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rrnompngmmhhavut")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("rrtbpulruosihpem")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("prvqlmjkdrnwypsx")
    public suspend fun rolloutName(`value`: Output<String>) {
        this.rolloutName = value
    }

    /**
     * @param value The list of step groups that define the orchestration.
     */
    @JvmName("itwaegxdchbtywlg")
    public suspend fun stepGroups(`value`: Output<List<StepGroupArgs>>) {
        this.stepGroups = value
    }

    @JvmName("ujlmhwbletjlypwr")
    public suspend fun stepGroups(vararg values: Output<StepGroupArgs>) {
        this.stepGroups = Output.all(values.asList())
    }

    /**
     * @param values The list of step groups that define the orchestration.
     */
    @JvmName("ycpdwotbgxqxmmjx")
    public suspend fun stepGroups(values: List<Output<StepGroupArgs>>) {
        this.stepGroups = Output.all(values)
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("nwncmjfysohrdhff")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
     */
    @JvmName("vxxbdifklktyacxv")
    public suspend fun targetServiceTopologyId(`value`: Output<String>) {
        this.targetServiceTopologyId = value
    }

    /**
     * @param value The reference to the artifact source resource Id where the payload is located.
     */
    @JvmName("rldhsnvhappylvqd")
    public suspend fun artifactSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactSourceId = mapped
    }

    /**
     * @param value The version of the build being deployed.
     */
    @JvmName("cwwpiawplftxbdtx")
    public suspend fun buildVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildVersion = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("qvihwcimfritojgp")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("kwjgffywagxfouxe")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("dmlffvxqlaskqdwh")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bdcmfxwyqhxridsh")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("jddhtrwwwyaxxftv")
    public suspend fun rolloutName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rolloutName = mapped
    }

    /**
     * @param value The list of step groups that define the orchestration.
     */
    @JvmName("oxnipkfvhsbxaaiv")
    public suspend fun stepGroups(`value`: List<StepGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepGroups = mapped
    }

    /**
     * @param argument The list of step groups that define the orchestration.
     */
    @JvmName("ssotsxupmuieprhw")
    public suspend fun stepGroups(argument: List<suspend StepGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { StepGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stepGroups = mapped
    }

    /**
     * @param argument The list of step groups that define the orchestration.
     */
    @JvmName("jpifqekekwxewmvo")
    public suspend fun stepGroups(vararg argument: suspend StepGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { StepGroupArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.stepGroups = mapped
    }

    /**
     * @param argument The list of step groups that define the orchestration.
     */
    @JvmName("frunotxtdmrfycvp")
    public suspend fun stepGroups(argument: suspend StepGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StepGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.stepGroups = mapped
    }

    /**
     * @param values The list of step groups that define the orchestration.
     */
    @JvmName("vhivjpvoybnukeaf")
    public suspend fun stepGroups(vararg values: StepGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepGroups = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("vlxhbyyitmbiefwm")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("mktwsvpbssdpywsf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The resource Id of the service topology from which service units are being referenced in step groups to be deployed.
     */
    @JvmName("udjgkldchsbvbntn")
    public suspend fun targetServiceTopologyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetServiceTopologyId = mapped
    }

    internal fun build(): RolloutArgs = RolloutArgs(
        artifactSourceId = artifactSourceId,
        buildVersion = buildVersion,
        identity = identity,
        location = location,
        resourceGroupName = resourceGroupName,
        rolloutName = rolloutName,
        stepGroups = stepGroups,
        tags = tags,
        targetServiceTopologyId = targetServiceTopologyId,
    )
}
