@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.ServiceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource representation of a service in a service topology.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var service = new AzureNative.DeploymentManager.Service("service", new()
 *     {
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myService",
 *         ServiceTopologyName = "myTopology",
 *         Tags = null,
 *         TargetLocation = "centralus",
 *         TargetSubscriptionId = "600c95c5-3ee5-44fe-b190-ca38a19adcd7",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewService(ctx, "service", &deploymentmanager.ServiceArgs{
 * 			Location:             pulumi.String("centralus"),
 * 			ResourceGroupName:    pulumi.String("myResourceGroup"),
 * 			ServiceName:          pulumi.String("myService"),
 * 			ServiceTopologyName:  pulumi.String("myTopology"),
 * 			Tags:                 nil,
 * 			TargetLocation:       pulumi.String("centralus"),
 * 			TargetSubscriptionId: pulumi.String("600c95c5-3ee5-44fe-b190-ca38a19adcd7"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Service;
 * import com.pulumi.azurenative.deploymentmanager.ServiceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var service = new Service("service", ServiceArgs.builder()
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myService")
 *             .serviceTopologyName("myTopology")
 *             .tags()
 *             .targetLocation("centralus")
 *             .targetSubscriptionId("600c95c5-3ee5-44fe-b190-ca38a19adcd7")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:Service myService /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}
 * ```
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the service resource.
 * @property serviceTopologyName The name of the service topology .
 * @property tags Resource tags.
 * @property targetLocation The Azure location to which the resources in the service belong to or should be deployed to.
 * @property targetSubscriptionId The subscription to which the resources in the service belong to or should be deployed to.
 */
public data class ServiceArgs(
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceTopologyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetLocation: Output<String>? = null,
    public val targetSubscriptionId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.ServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.ServiceArgs =
        com.pulumi.azurenative.deploymentmanager.ServiceArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetLocation(targetLocation?.applyValue({ args0 -> args0 }))
            .targetSubscriptionId(targetSubscriptionId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceTopologyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetLocation: Output<String>? = null

    private var targetSubscriptionId: Output<String>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("annydscxqecfyhiv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hahcqblmdjbhfcre")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("vcowgsxbbvyraonb")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("kexucxpmcqdqlntc")
    public suspend fun serviceTopologyName(`value`: Output<String>) {
        this.serviceTopologyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("tmrjcdlgyqmuawii")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure location to which the resources in the service belong to or should be deployed to.
     */
    @JvmName("gekyykqcwelfaqak")
    public suspend fun targetLocation(`value`: Output<String>) {
        this.targetLocation = value
    }

    /**
     * @param value The subscription to which the resources in the service belong to or should be deployed to.
     */
    @JvmName("hqolmatatjkqmclm")
    public suspend fun targetSubscriptionId(`value`: Output<String>) {
        this.targetSubscriptionId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qanwdugnufcwaeik")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("jbrnvfwekhkhcisb")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("fspwgrcredljacyr")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("mycgikhkjwuhibox")
    public suspend fun serviceTopologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTopologyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hrxdhidtjvgicxxq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("sfwixcjjlbenickv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Azure location to which the resources in the service belong to or should be deployed to.
     */
    @JvmName("xtujpxudwqfgjcvs")
    public suspend fun targetLocation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetLocation = mapped
    }

    /**
     * @param value The subscription to which the resources in the service belong to or should be deployed to.
     */
    @JvmName("kldlgeslunewckeg")
    public suspend fun targetSubscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetSubscriptionId = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        location = location,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceTopologyName = serviceTopologyName,
        tags = tags,
        targetLocation = targetLocation,
        targetSubscriptionId = targetSubscriptionId,
    )
}
