@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceTopology].
 */
@PulumiTagMarker
public class ServiceTopologyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceTopologyArgs = ServiceTopologyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceTopologyArgsBuilder.() -> Unit) {
        val builder = ServiceTopologyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceTopology {
        val builtJavaResource =
            com.pulumi.azurenative.deploymentmanager.ServiceTopology(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceTopology(builtJavaResource)
    }
}

/**
 * The resource representation of a service topology.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create a topology with Artifact Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTopology = new AzureNative.DeploymentManager.ServiceTopology("serviceTopology", new()
 *     {
 *         ArtifactSourceId = "Microsoft.DeploymentManager/artifactSources/myArtifactSource",
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceTopologyName = "myTopology",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceTopology(ctx, "serviceTopology", &deploymentmanager.ServiceTopologyArgs{
 * 			ArtifactSourceId:    pulumi.String("Microsoft.DeploymentManager/artifactSources/myArtifactSource"),
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			Tags:                nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopology;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTopology = new ServiceTopology("serviceTopology", ServiceTopologyArgs.builder()
 *             .artifactSourceId("Microsoft.DeploymentManager/artifactSources/myArtifactSource")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceTopologyName("myTopology")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a topology without Artifact Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTopology = new AzureNative.DeploymentManager.ServiceTopology("serviceTopology", new()
 *     {
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceTopologyName = "myTopology",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceTopology(ctx, "serviceTopology", &deploymentmanager.ServiceTopologyArgs{
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			Tags:                nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopology;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTopology = new ServiceTopology("serviceTopology", ServiceTopologyArgs.builder()
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceTopologyName("myTopology")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ServiceTopology myTopology /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}
 * ```
 */
public class ServiceTopology internal constructor(
    override val javaResource: com.pulumi.azurenative.deploymentmanager.ServiceTopology,
) : KotlinCustomResource(javaResource, ServiceTopologyMapper) {
    /**
     * The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
     */
    public val artifactSourceId: Output<String>?
        get() = javaResource.artifactSourceId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceTopologyMapper : ResourceMapper<ServiceTopology> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deploymentmanager.ServiceTopology::class == javaResource::class

    override fun map(javaResource: Resource): ServiceTopology = ServiceTopology(
        javaResource as
            com.pulumi.azurenative.deploymentmanager.ServiceTopology,
    )
}

/**
 * @see [ServiceTopology].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceTopology].
 */
public suspend fun serviceTopology(
    name: String,
    block: suspend ServiceTopologyResourceBuilder.() -> Unit,
): ServiceTopology {
    val builder = ServiceTopologyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceTopology].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceTopology(name: String): ServiceTopology {
    val builder = ServiceTopologyResourceBuilder()
    builder.name(name)
    return builder.build()
}
