@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource representation of a service topology.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create a topology with Artifact Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTopology = new AzureNative.DeploymentManager.ServiceTopology("serviceTopology", new()
 *     {
 *         ArtifactSourceId = "Microsoft.DeploymentManager/artifactSources/myArtifactSource",
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceTopologyName = "myTopology",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceTopology(ctx, "serviceTopology", &deploymentmanager.ServiceTopologyArgs{
 * 			ArtifactSourceId:    pulumi.String("Microsoft.DeploymentManager/artifactSources/myArtifactSource"),
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			Tags:                nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopology;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTopology = new ServiceTopology("serviceTopology", ServiceTopologyArgs.builder()
 *             .artifactSourceId("Microsoft.DeploymentManager/artifactSources/myArtifactSource")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceTopologyName("myTopology")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create a topology without Artifact Source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceTopology = new AzureNative.DeploymentManager.ServiceTopology("serviceTopology", new()
 *     {
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceTopologyName = "myTopology",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceTopology(ctx, "serviceTopology", &deploymentmanager.ServiceTopologyArgs{
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			Tags:                nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopology;
 * import com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceTopology = new ServiceTopology("serviceTopology", ServiceTopologyArgs.builder()
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceTopologyName("myTopology")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ServiceTopology myTopology /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}
 * ```
 * @property artifactSourceId The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceTopologyName The name of the service topology .
 * @property tags Resource tags.
 */
public data class ServiceTopologyArgs(
    public val artifactSourceId: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceTopologyName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs =
        com.pulumi.azurenative.deploymentmanager.ServiceTopologyArgs.builder()
            .artifactSourceId(artifactSourceId?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceTopologyArgs].
 */
@PulumiTagMarker
public class ServiceTopologyArgsBuilder internal constructor() {
    private var artifactSourceId: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceTopologyName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
     */
    @JvmName("rxfjyrlsrowxbucn")
    public suspend fun artifactSourceId(`value`: Output<String>) {
        this.artifactSourceId = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("vtubtxgrwomixnyk")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("fkignfyutlkueask")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("lpdvvwrnbkbqsoli")
    public suspend fun serviceTopologyName(`value`: Output<String>) {
        this.serviceTopologyName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("aptgfoobvglvorfw")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The resource Id of the artifact source that contains the artifacts that can be referenced in the service units.
     */
    @JvmName("qduefsmjoxegmfpo")
    public suspend fun artifactSourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifactSourceId = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("pylqowjarapcqnog")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("hkxiahabsfwlxbmr")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("tveujlrukreacnks")
    public suspend fun serviceTopologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTopologyName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("mxslmxcfroxuimwk")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("uutuujpxlpolsigw")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceTopologyArgs = ServiceTopologyArgs(
        artifactSourceId = artifactSourceId,
        location = location,
        resourceGroupName = resourceGroupName,
        serviceTopologyName = serviceTopologyName,
        tags = tags,
    )
}
