@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceUnitArtifactsResponse
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.ServiceUnitArtifactsResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ServiceUnit].
 */
@PulumiTagMarker
public class ServiceUnitResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceUnitArgs = ServiceUnitArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceUnitArgsBuilder.() -> Unit) {
        val builder = ServiceUnitArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ServiceUnit {
        val builtJavaResource =
            com.pulumi.azurenative.deploymentmanager.ServiceUnit(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ServiceUnit(builtJavaResource)
    }
}

/**
 * Represents the response of a service unit resource.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create service unit using SAS URIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceUnit = new AzureNative.DeploymentManager.ServiceUnit("serviceUnit", new()
 *     {
 *         Artifacts = new AzureNative.DeploymentManager.Inputs.ServiceUnitArtifactsArgs
 *         {
 *             ParametersUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             TemplateUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *         },
 *         DeploymentMode = AzureNative.DeploymentManager.DeploymentMode.Incremental,
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myService",
 *         ServiceTopologyName = "myTopology",
 *         ServiceUnitName = "myServiceUnit",
 *         Tags = null,
 *         TargetResourceGroup = "myDeploymentResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceUnit(ctx, "serviceUnit", &deploymentmanager.ServiceUnitArgs{
 * 			Artifacts: &deploymentmanager.ServiceUnitArtifactsArgs{
 * 				ParametersUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * 				TemplateUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * 			},
 * 			DeploymentMode:      deploymentmanager.DeploymentModeIncremental,
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myService"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			ServiceUnitName:     pulumi.String("myServiceUnit"),
 * 			Tags:                nil,
 * 			TargetResourceGroup: pulumi.String("myDeploymentResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnit;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceUnit = new ServiceUnit("serviceUnit", ServiceUnitArgs.builder()
 *             .artifacts(Map.ofEntries(
 *                 Map.entry("parametersUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("templateUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D")
 *             ))
 *             .deploymentMode("Incremental")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myService")
 *             .serviceTopologyName("myTopology")
 *             .serviceUnitName("myServiceUnit")
 *             .tags()
 *             .targetResourceGroup("myDeploymentResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create service unit using relative paths into the artifact source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceUnit = new AzureNative.DeploymentManager.ServiceUnit("serviceUnit", new()
 *     {
 *         Artifacts = new AzureNative.DeploymentManager.Inputs.ServiceUnitArtifactsArgs
 *         {
 *             ParametersArtifactSourceRelativePath = "parameter/myTopologyUnit.parameters.json",
 *             TemplateArtifactSourceRelativePath = "templates/myTopologyUnit.template.json",
 *         },
 *         DeploymentMode = AzureNative.DeploymentManager.DeploymentMode.Incremental,
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myService",
 *         ServiceTopologyName = "myTopology",
 *         ServiceUnitName = "myServiceUnit",
 *         Tags = null,
 *         TargetResourceGroup = "myDeploymentResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceUnit(ctx, "serviceUnit", &deploymentmanager.ServiceUnitArgs{
 * 			Artifacts: &deploymentmanager.ServiceUnitArtifactsArgs{
 * 				ParametersArtifactSourceRelativePath: pulumi.String("parameter/myTopologyUnit.parameters.json"),
 * 				TemplateArtifactSourceRelativePath:   pulumi.String("templates/myTopologyUnit.template.json"),
 * 			},
 * 			DeploymentMode:      deploymentmanager.DeploymentModeIncremental,
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myService"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			ServiceUnitName:     pulumi.String("myServiceUnit"),
 * 			Tags:                nil,
 * 			TargetResourceGroup: pulumi.String("myDeploymentResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnit;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceUnit = new ServiceUnit("serviceUnit", ServiceUnitArgs.builder()
 *             .artifacts(Map.ofEntries(
 *                 Map.entry("parametersArtifactSourceRelativePath", "parameter/myTopologyUnit.parameters.json"),
 *                 Map.entry("templateArtifactSourceRelativePath", "templates/myTopologyUnit.template.json")
 *             ))
 *             .deploymentMode("Incremental")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myService")
 *             .serviceTopologyName("myTopology")
 *             .serviceUnitName("myServiceUnit")
 *             .tags()
 *             .targetResourceGroup("myDeploymentResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ServiceUnit myServiceUnit /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits/{serviceUnitName}
 * ```
 */
public class ServiceUnit internal constructor(
    override val javaResource: com.pulumi.azurenative.deploymentmanager.ServiceUnit,
) : KotlinCustomResource(javaResource, ServiceUnitMapper) {
    /**
     * The artifacts for the service unit.
     */
    public val artifacts: Output<ServiceUnitArtifactsResponse>?
        get() = javaResource.artifacts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Describes the type of ARM deployment to be performed on the resource.
     */
    public val deploymentMode: Output<String>
        get() = javaResource.deploymentMode().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
     */
    public val targetResourceGroup: Output<String>
        get() = javaResource.targetResourceGroup().applyValue({ args0 -> args0 })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ServiceUnitMapper : ResourceMapper<ServiceUnit> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deploymentmanager.ServiceUnit::class == javaResource::class

    override fun map(javaResource: Resource): ServiceUnit = ServiceUnit(
        javaResource as
            com.pulumi.azurenative.deploymentmanager.ServiceUnit,
    )
}

/**
 * @see [ServiceUnit].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ServiceUnit].
 */
public suspend fun serviceUnit(name: String, block: suspend ServiceUnitResourceBuilder.() -> Unit):
    ServiceUnit {
    val builder = ServiceUnitResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ServiceUnit].
 * @param name The _unique_ name of the resulting resource.
 */
public fun serviceUnit(name: String): ServiceUnit {
    val builder = ServiceUnitResourceBuilder()
    builder.name(name)
    return builder.build()
}
