@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.enums.DeploymentMode
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.ServiceUnitArtifactsArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.ServiceUnitArtifactsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents the response of a service unit resource.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * ## Example Usage
 * ### Create service unit using SAS URIs
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceUnit = new AzureNative.DeploymentManager.ServiceUnit("serviceUnit", new()
 *     {
 *         Artifacts = new AzureNative.DeploymentManager.Inputs.ServiceUnitArtifactsArgs
 *         {
 *             ParametersUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *             TemplateUri = "https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D",
 *         },
 *         DeploymentMode = AzureNative.DeploymentManager.DeploymentMode.Incremental,
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myService",
 *         ServiceTopologyName = "myTopology",
 *         ServiceUnitName = "myServiceUnit",
 *         Tags = null,
 *         TargetResourceGroup = "myDeploymentResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceUnit(ctx, "serviceUnit", &deploymentmanager.ServiceUnitArgs{
 * 			Artifacts: &deploymentmanager.ServiceUnitArtifactsArgs{
 * 				ParametersUri: pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * 				TemplateUri:   pulumi.String("https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 * 			},
 * 			DeploymentMode:      deploymentmanager.DeploymentModeIncremental,
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myService"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			ServiceUnitName:     pulumi.String("myServiceUnit"),
 * 			Tags:                nil,
 * 			TargetResourceGroup: pulumi.String("myDeploymentResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnit;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceUnit = new ServiceUnit("serviceUnit", ServiceUnitArgs.builder()
 *             .artifacts(Map.ofEntries(
 *                 Map.entry("parametersUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource/parameter/myTopologyUnit.parameters.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D"),
 *                 Map.entry("templateUri", "https://mystorageaccount.blob.core.windows.net/myartifactsource/templates/myTopologyUnit.template.json?st=2018-07-07T14%3A10%3A00Z&se=2019-12-31T15%3A10%3A00Z&sp=rl&sv=2017-04-17&sr=c&sig=Yh2SoJ1NhhLRwCLln7de%2Fkabcdefghijklmno5sWEIk%3D")
 *             ))
 *             .deploymentMode("Incremental")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myService")
 *             .serviceTopologyName("myTopology")
 *             .serviceUnitName("myServiceUnit")
 *             .tags()
 *             .targetResourceGroup("myDeploymentResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Create service unit using relative paths into the artifact source
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var serviceUnit = new AzureNative.DeploymentManager.ServiceUnit("serviceUnit", new()
 *     {
 *         Artifacts = new AzureNative.DeploymentManager.Inputs.ServiceUnitArtifactsArgs
 *         {
 *             ParametersArtifactSourceRelativePath = "parameter/myTopologyUnit.parameters.json",
 *             TemplateArtifactSourceRelativePath = "templates/myTopologyUnit.template.json",
 *         },
 *         DeploymentMode = AzureNative.DeploymentManager.DeploymentMode.Incremental,
 *         Location = "centralus",
 *         ResourceGroupName = "myResourceGroup",
 *         ServiceName = "myService",
 *         ServiceTopologyName = "myTopology",
 *         ServiceUnitName = "myServiceUnit",
 *         Tags = null,
 *         TargetResourceGroup = "myDeploymentResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewServiceUnit(ctx, "serviceUnit", &deploymentmanager.ServiceUnitArgs{
 * 			Artifacts: &deploymentmanager.ServiceUnitArtifactsArgs{
 * 				ParametersArtifactSourceRelativePath: pulumi.String("parameter/myTopologyUnit.parameters.json"),
 * 				TemplateArtifactSourceRelativePath:   pulumi.String("templates/myTopologyUnit.template.json"),
 * 			},
 * 			DeploymentMode:      deploymentmanager.DeploymentModeIncremental,
 * 			Location:            pulumi.String("centralus"),
 * 			ResourceGroupName:   pulumi.String("myResourceGroup"),
 * 			ServiceName:         pulumi.String("myService"),
 * 			ServiceTopologyName: pulumi.String("myTopology"),
 * 			ServiceUnitName:     pulumi.String("myServiceUnit"),
 * 			Tags:                nil,
 * 			TargetResourceGroup: pulumi.String("myDeploymentResourceGroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnit;
 * import com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var serviceUnit = new ServiceUnit("serviceUnit", ServiceUnitArgs.builder()
 *             .artifacts(Map.ofEntries(
 *                 Map.entry("parametersArtifactSourceRelativePath", "parameter/myTopologyUnit.parameters.json"),
 *                 Map.entry("templateArtifactSourceRelativePath", "templates/myTopologyUnit.template.json")
 *             ))
 *             .deploymentMode("Incremental")
 *             .location("centralus")
 *             .resourceGroupName("myResourceGroup")
 *             .serviceName("myService")
 *             .serviceTopologyName("myTopology")
 *             .serviceUnitName("myServiceUnit")
 *             .tags()
 *             .targetResourceGroup("myDeploymentResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:ServiceUnit myServiceUnit /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/serviceTopologies/{serviceTopologyName}/services/{serviceName}/serviceUnits/{serviceUnitName}
 * ```
 * @property artifacts The artifacts for the service unit.
 * @property deploymentMode Describes the type of ARM deployment to be performed on the resource.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the service resource.
 * @property serviceTopologyName The name of the service topology .
 * @property serviceUnitName The name of the service unit resource.
 * @property tags Resource tags.
 * @property targetResourceGroup The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
 */
public data class ServiceUnitArgs(
    public val artifacts: Output<ServiceUnitArtifactsArgs>? = null,
    public val deploymentMode: Output<DeploymentMode>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val serviceName: Output<String>? = null,
    public val serviceTopologyName: Output<String>? = null,
    public val serviceUnitName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val targetResourceGroup: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs =
        com.pulumi.azurenative.deploymentmanager.ServiceUnitArgs.builder()
            .artifacts(artifacts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .deploymentMode(deploymentMode?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName?.applyValue({ args0 -> args0 }))
            .serviceUnitName(serviceUnitName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .targetResourceGroup(targetResourceGroup?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceUnitArgs].
 */
@PulumiTagMarker
public class ServiceUnitArgsBuilder internal constructor() {
    private var artifacts: Output<ServiceUnitArtifactsArgs>? = null

    private var deploymentMode: Output<DeploymentMode>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var serviceName: Output<String>? = null

    private var serviceTopologyName: Output<String>? = null

    private var serviceUnitName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var targetResourceGroup: Output<String>? = null

    /**
     * @param value The artifacts for the service unit.
     */
    @JvmName("hcnqdtxwmpbherjq")
    public suspend fun artifacts(`value`: Output<ServiceUnitArtifactsArgs>) {
        this.artifacts = value
    }

    /**
     * @param value Describes the type of ARM deployment to be performed on the resource.
     */
    @JvmName("ciumctueexcjowcn")
    public suspend fun deploymentMode(`value`: Output<DeploymentMode>) {
        this.deploymentMode = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("feawknsayrygjiuv")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("pfnjnaxcfdltsyoy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("aqrcbdjyygjpimoe")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("fnsjaetmajnwyilg")
    public suspend fun serviceTopologyName(`value`: Output<String>) {
        this.serviceTopologyName = value
    }

    /**
     * @param value The name of the service unit resource.
     */
    @JvmName("hsajilefhhkbeseu")
    public suspend fun serviceUnitName(`value`: Output<String>) {
        this.serviceUnitName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("berxacvtmgoydhnn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
     */
    @JvmName("oiljbwbkmyftobud")
    public suspend fun targetResourceGroup(`value`: Output<String>) {
        this.targetResourceGroup = value
    }

    /**
     * @param value The artifacts for the service unit.
     */
    @JvmName("dfnseccjihgbtfsj")
    public suspend fun artifacts(`value`: ServiceUnitArtifactsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.artifacts = mapped
    }

    /**
     * @param argument The artifacts for the service unit.
     */
    @JvmName("qeiwbyfhwtqxsiqu")
    public suspend fun artifacts(argument: suspend ServiceUnitArtifactsArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceUnitArtifactsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.artifacts = mapped
    }

    /**
     * @param value Describes the type of ARM deployment to be performed on the resource.
     */
    @JvmName("nwmigdpiedooywuu")
    public suspend fun deploymentMode(`value`: DeploymentMode?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deploymentMode = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("jcdhlrybtbqknkoo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cidvjmuymffqwgoq")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("bvgokofujppehdvw")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("svmwmdrcaanfoqya")
    public suspend fun serviceTopologyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceTopologyName = mapped
    }

    /**
     * @param value The name of the service unit resource.
     */
    @JvmName("leytcjkbnaovmmyx")
    public suspend fun serviceUnitName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUnitName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("bqvhodaliitrjrut")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("dqkpqbtrchxjbecr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The Azure Resource Group to which the resources in the service unit belong to or should be deployed to.
     */
    @JvmName("ddptheoxalylpmus")
    public suspend fun targetResourceGroup(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetResourceGroup = mapped
    }

    internal fun build(): ServiceUnitArgs = ServiceUnitArgs(
        artifacts = artifacts,
        deploymentMode = deploymentMode,
        location = location,
        resourceGroupName = resourceGroupName,
        serviceName = serviceName,
        serviceTopologyName = serviceTopologyName,
        serviceUnitName = serviceUnitName,
        tags = tags,
        targetResourceGroup = targetResourceGroup,
    )
}
