@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.HealthCheckStepPropertiesResponse
import com.pulumi.azurenative.deploymentmanager.kotlin.outputs.WaitStepPropertiesResponse
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Step].
 */
@PulumiTagMarker
public class StepResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StepArgs = StepArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StepArgsBuilder.() -> Unit) {
        val builder = StepArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Step {
        val builtJavaResource = com.pulumi.azurenative.deploymentmanager.Step(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Step(builtJavaResource)
    }
}

/**
 * The resource representation of a rollout step.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create health check step
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var step = new AzureNative.DeploymentManager.Step("step", new()
 *     {
 *         Location = "centralus",
 *         Properties = new AzureNative.DeploymentManager.Inputs.HealthCheckStepPropertiesArgs
 *         {
 *             Attributes = new AzureNative.DeploymentManager.Inputs.RestHealthCheckStepAttributesArgs
 *             {
 *                 HealthChecks = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.RestHealthCheckArgs
 *                     {
 *                         Name = "appHealth",
 *                         Request = new AzureNative.DeploymentManager.Inputs.RestRequestArgs
 *                         {
 *                             Authentication = new AzureNative.DeploymentManager.Inputs.ApiKeyAuthenticationArgs
 *                             {
 *                                 In = AzureNative.DeploymentManager.RestAuthLocation.Query,
 *                                 Name = "Code",
 *                                 Type = "ApiKey",
 *                                 Value = "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 *                             },
 *                             Method = AzureNative.DeploymentManager.RestRequestMethod.GET,
 *                             Uri = "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus",
 *                         },
 *                         Response = new AzureNative.DeploymentManager.Inputs.RestResponseArgs
 *                         {
 *                             Regex = new AzureNative.DeploymentManager.Inputs.RestResponseRegexArgs
 *                             {
 *                                 MatchQuantifier = AzureNative.DeploymentManager.RestMatchQuantifier.All,
 *                                 Matches = new[]
 *                                 {
 *                                     "(?i)Contoso-App",
 *                                     @"(?i)""health_status"":((.|
 * )*)""(green|yellow)""",
 *                                     "(?mi)^(\"application_host\": 94781052)$",
 *                                 },
 *                             },
 *                             SuccessStatusCodes = new[]
 *                             {
 *                                 "OK",
 *                             },
 *                         },
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.RestHealthCheckArgs
 *                     {
 *                         Name = "serviceHealth",
 *                         Request = new AzureNative.DeploymentManager.Inputs.RestRequestArgs
 *                         {
 *                             Authentication = new AzureNative.DeploymentManager.Inputs.ApiKeyAuthenticationArgs
 *                             {
 *                                 In = AzureNative.DeploymentManager.RestAuthLocation.Header,
 *                                 Name = "code",
 *                                 Type = "ApiKey",
 *                                 Value = "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 *                             },
 *                             Method = AzureNative.DeploymentManager.RestRequestMethod.GET,
 *                             Uri = "https://resthealth.healthservice.com/api/services/contosoService/healthStatus",
 *                         },
 *                         Response = new AzureNative.DeploymentManager.Inputs.RestResponseArgs
 *                         {
 *                             Regex = new AzureNative.DeploymentManager.Inputs.RestResponseRegexArgs
 *                             {
 *                                 MatchQuantifier = AzureNative.DeploymentManager.RestMatchQuantifier.All,
 *                                 Matches = new[]
 *                                 {
 *                                     "(?i)Contoso-Service-EndToEnd",
 *                                     @"(?i)""health_status"":((.|
 * )*)""(green)""",
 *                                 },
 *                             },
 *                             SuccessStatusCodes = new[]
 *                             {
 *                                 "OK",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 HealthyStateDuration = "PT2H",
 *                 MaxElasticDuration = "PT30M",
 *                 Type = "REST",
 *                 WaitDuration = "PT15M",
 *             },
 *             StepType = "HealthCheck",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StepName = "healthCheckStep",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewStep(ctx, "step", &deploymentmanager.StepArgs{
 * 			Location: pulumi.String("centralus"),
 * 			Properties: deploymentmanager.HealthCheckStepProperties{
 * 				Attributes: deploymentmanager.RestHealthCheckStepAttributes{
 * 					HealthChecks: []deploymentmanager.RestHealthCheck{
 * 						{
 * 							Name: "appHealth",
 * 							Request: {
 * 								Authentication: {
 * 									In:    deploymentmanager.RestAuthLocationQuery,
 * 									Name:  "Code",
 * 									Type:  "ApiKey",
 * 									Value: "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 * 								},
 * 								Method: deploymentmanager.RestRequestMethodGET,
 * 								Uri:    "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus",
 * 							},
 * 							Response: {
 * 								Regex: {
 * 									MatchQuantifier: deploymentmanager.RestMatchQuantifierAll,
 * 									Matches: []string{
 * 										"(?i)Contoso-App",
 * 										"(?i)\"health_status\":((.|\n)*)\"(green|yellow)\"",
 * 										"(?mi)^(\"application_host\": 94781052)$",
 * 									},
 * 								},
 * 								SuccessStatusCodes: []string{
 * 									"OK",
 * 								},
 * 							},
 * 						},
 * 						{
 * 							Name: "serviceHealth",
 * 							Request: {
 * 								Authentication: {
 * 									In:    deploymentmanager.RestAuthLocationHeader,
 * 									Name:  "code",
 * 									Type:  "ApiKey",
 * 									Value: "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 * 								},
 * 								Method: deploymentmanager.RestRequestMethodGET,
 * 								Uri:    "https://resthealth.healthservice.com/api/services/contosoService/healthStatus",
 * 							},
 * 							Response: {
 * 								Regex: {
 * 									MatchQuantifier: deploymentmanager.RestMatchQuantifierAll,
 * 									Matches: []string{
 * 										"(?i)Contoso-Service-EndToEnd",
 * 										"(?i)\"health_status\":((.|\n)*)\"(green)\"",
 * 									},
 * 								},
 * 								SuccessStatusCodes: []string{
 * 									"OK",
 * 								},
 * 							},
 * 						},
 * 					},
 * 					HealthyStateDuration: "PT2H",
 * 					MaxElasticDuration:   "PT30M",
 * 					Type:                 "REST",
 * 					WaitDuration:         "PT15M",
 * 				},
 * 				StepType: "HealthCheck",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StepName:          pulumi.String("healthCheckStep"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Step;
 * import com.pulumi.azurenative.deploymentmanager.StepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var step = new Step("step", StepArgs.builder()
 *             .location("centralus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("attributes", Map.ofEntries(
 *                     Map.entry("healthChecks",
 *                         Map.ofEntries(
 *                             Map.entry("name", "appHealth"),
 *                             Map.entry("request", Map.ofEntries(
 *                                 Map.entry("authentication", Map.ofEntries(
 *                                     Map.entry("in", "Query"),
 *                                     Map.entry("name", "Code"),
 *                                     Map.entry("type", "ApiKey"),
 *                                     Map.entry("value", "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==")
 *                                 )),
 *                                 Map.entry("method", "GET"),
 *                                 Map.entry("uri", "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus")
 *                             )),
 *                             Map.entry("response", Map.ofEntries(
 *                                 Map.entry("regex", Map.ofEntries(
 *                                     Map.entry("matchQuantifier", "All"),
 *                                     Map.entry("matches",
 *                                         "(?i)Contoso-App",
 *                                         """
 * (?i)"health_status":((.|
 * )*)"(green|yellow)"                                        """,
 *                                         "(?mi)^(\"application_host\": 94781052)$")
 *                                 )),
 *                                 Map.entry("successStatusCodes", "OK")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("name", "serviceHealth"),
 *                             Map.entry("request", Map.ofEntries(
 *                                 Map.entry("authentication", Map.ofEntries(
 *                                     Map.entry("in", "Header"),
 *                                     Map.entry("name", "code"),
 *                                     Map.entry("type", "ApiKey"),
 *                                     Map.entry("value", "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==")
 *                                 )),
 *                                 Map.entry("method", "GET"),
 *                                 Map.entry("uri", "https://resthealth.healthservice.com/api/services/contosoService/healthStatus")
 *                             )),
 *                             Map.entry("response", Map.ofEntries(
 *                                 Map.entry("regex", Map.ofEntries(
 *                                     Map.entry("matchQuantifier", "All"),
 *                                     Map.entry("matches",
 *                                         "(?i)Contoso-Service-EndToEnd",
 *                                         """
 * (?i)"health_status":((.|
 * )*)"(green)"                                        """)
 *                                 )),
 *                                 Map.entry("successStatusCodes", "OK")
 *                             ))
 *                         )),
 *                     Map.entry("healthyStateDuration", "PT2H"),
 *                     Map.entry("maxElasticDuration", "PT30M"),
 *                     Map.entry("type", "REST"),
 *                     Map.entry("waitDuration", "PT15M")
 *                 )),
 *                 Map.entry("stepType", "HealthCheck")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .stepName("healthCheckStep")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create wait step
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var step = new AzureNative.DeploymentManager.Step("step", new()
 *     {
 *         Location = "centralus",
 *         Properties = new AzureNative.DeploymentManager.Inputs.WaitStepPropertiesArgs
 *         {
 *             Attributes = new AzureNative.DeploymentManager.Inputs.WaitStepAttributesArgs
 *             {
 *                 Duration = "PT20M",
 *             },
 *             StepType = "Wait",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StepName = "waitStep",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewStep(ctx, "step", &deploymentmanager.StepArgs{
 * 			Location: pulumi.String("centralus"),
 * 			Properties: deploymentmanager.WaitStepProperties{
 * 				Attributes: deploymentmanager.WaitStepAttributes{
 * 					Duration: "PT20M",
 * 				},
 * 				StepType: "Wait",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StepName:          pulumi.String("waitStep"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Step;
 * import com.pulumi.azurenative.deploymentmanager.StepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var step = new Step("step", StepArgs.builder()
 *             .location("centralus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("attributes", Map.of("duration", "PT20M")),
 *                 Map.entry("stepType", "Wait")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .stepName("waitStep")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:Step waitStep /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/steps/{stepName}
 * ```
 */
public class Step internal constructor(
    override val javaResource: com.pulumi.azurenative.deploymentmanager.Step,
) : KotlinCustomResource(javaResource, StepMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties that define the step.
     */
    public val properties:
        Output<Either<HealthCheckStepPropertiesResponse, WaitStepPropertiesResponse>>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deploymentmanager.kotlin.outputs.HealthCheckStepPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.deploymentmanager.kotlin.outputs.WaitStepPropertiesResponse.Companion.toKotlin(args0)
                    })
                },
            )
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object StepMapper : ResourceMapper<Step> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.deploymentmanager.Step::class == javaResource::class

    override fun map(javaResource: Resource): Step = Step(
        javaResource as
            com.pulumi.azurenative.deploymentmanager.Step,
    )
}

/**
 * @see [Step].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Step].
 */
public suspend fun step(name: String, block: suspend StepResourceBuilder.() -> Unit): Step {
    val builder = StepResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Step].
 * @param name The _unique_ name of the resulting resource.
 */
public fun step(name: String): Step {
    val builder = StepResourceBuilder()
    builder.name(name)
    return builder.build()
}
