@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin

import com.pulumi.azurenative.deploymentmanager.StepArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.HealthCheckStepPropertiesArgs
import com.pulumi.azurenative.deploymentmanager.kotlin.inputs.WaitStepPropertiesArgs
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The resource representation of a rollout step.
 * Azure REST API version: 2019-11-01-preview. Prior API version in Azure Native 1.x: 2019-11-01-preview.
 * Other available API versions: 2018-09-01-preview.
 * ## Example Usage
 * ### Create health check step
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var step = new AzureNative.DeploymentManager.Step("step", new()
 *     {
 *         Location = "centralus",
 *         Properties = new AzureNative.DeploymentManager.Inputs.HealthCheckStepPropertiesArgs
 *         {
 *             Attributes = new AzureNative.DeploymentManager.Inputs.RestHealthCheckStepAttributesArgs
 *             {
 *                 HealthChecks = new[]
 *                 {
 *                     new AzureNative.DeploymentManager.Inputs.RestHealthCheckArgs
 *                     {
 *                         Name = "appHealth",
 *                         Request = new AzureNative.DeploymentManager.Inputs.RestRequestArgs
 *                         {
 *                             Authentication = new AzureNative.DeploymentManager.Inputs.ApiKeyAuthenticationArgs
 *                             {
 *                                 In = AzureNative.DeploymentManager.RestAuthLocation.Query,
 *                                 Name = "Code",
 *                                 Type = "ApiKey",
 *                                 Value = "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 *                             },
 *                             Method = AzureNative.DeploymentManager.RestRequestMethod.GET,
 *                             Uri = "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus",
 *                         },
 *                         Response = new AzureNative.DeploymentManager.Inputs.RestResponseArgs
 *                         {
 *                             Regex = new AzureNative.DeploymentManager.Inputs.RestResponseRegexArgs
 *                             {
 *                                 MatchQuantifier = AzureNative.DeploymentManager.RestMatchQuantifier.All,
 *                                 Matches = new[]
 *                                 {
 *                                     "(?i)Contoso-App",
 *                                     @"(?i)""health_status"":((.|
 * )*)""(green|yellow)""",
 *                                     "(?mi)^(\"application_host\": 94781052)$",
 *                                 },
 *                             },
 *                             SuccessStatusCodes = new[]
 *                             {
 *                                 "OK",
 *                             },
 *                         },
 *                     },
 *                     new AzureNative.DeploymentManager.Inputs.RestHealthCheckArgs
 *                     {
 *                         Name = "serviceHealth",
 *                         Request = new AzureNative.DeploymentManager.Inputs.RestRequestArgs
 *                         {
 *                             Authentication = new AzureNative.DeploymentManager.Inputs.ApiKeyAuthenticationArgs
 *                             {
 *                                 In = AzureNative.DeploymentManager.RestAuthLocation.Header,
 *                                 Name = "code",
 *                                 Type = "ApiKey",
 *                                 Value = "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 *                             },
 *                             Method = AzureNative.DeploymentManager.RestRequestMethod.GET,
 *                             Uri = "https://resthealth.healthservice.com/api/services/contosoService/healthStatus",
 *                         },
 *                         Response = new AzureNative.DeploymentManager.Inputs.RestResponseArgs
 *                         {
 *                             Regex = new AzureNative.DeploymentManager.Inputs.RestResponseRegexArgs
 *                             {
 *                                 MatchQuantifier = AzureNative.DeploymentManager.RestMatchQuantifier.All,
 *                                 Matches = new[]
 *                                 {
 *                                     "(?i)Contoso-Service-EndToEnd",
 *                                     @"(?i)""health_status"":((.|
 * )*)""(green)""",
 *                                 },
 *                             },
 *                             SuccessStatusCodes = new[]
 *                             {
 *                                 "OK",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 HealthyStateDuration = "PT2H",
 *                 MaxElasticDuration = "PT30M",
 *                 Type = "REST",
 *                 WaitDuration = "PT15M",
 *             },
 *             StepType = "HealthCheck",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StepName = "healthCheckStep",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewStep(ctx, "step", &deploymentmanager.StepArgs{
 * 			Location: pulumi.String("centralus"),
 * 			Properties: deploymentmanager.HealthCheckStepProperties{
 * 				Attributes: deploymentmanager.RestHealthCheckStepAttributes{
 * 					HealthChecks: []deploymentmanager.RestHealthCheck{
 * 						{
 * 							Name: "appHealth",
 * 							Request: {
 * 								Authentication: {
 * 									In:    deploymentmanager.RestAuthLocationQuery,
 * 									Name:  "Code",
 * 									Type:  "ApiKey",
 * 									Value: "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 * 								},
 * 								Method: deploymentmanager.RestRequestMethodGET,
 * 								Uri:    "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus",
 * 							},
 * 							Response: {
 * 								Regex: {
 * 									MatchQuantifier: deploymentmanager.RestMatchQuantifierAll,
 * 									Matches: []string{
 * 										"(?i)Contoso-App",
 * 										"(?i)\"health_status\":((.|\n)*)\"(green|yellow)\"",
 * 										"(?mi)^(\"application_host\": 94781052)$",
 * 									},
 * 								},
 * 								SuccessStatusCodes: []string{
 * 									"OK",
 * 								},
 * 							},
 * 						},
 * 						{
 * 							Name: "serviceHealth",
 * 							Request: {
 * 								Authentication: {
 * 									In:    deploymentmanager.RestAuthLocationHeader,
 * 									Name:  "code",
 * 									Type:  "ApiKey",
 * 									Value: "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==",
 * 								},
 * 								Method: deploymentmanager.RestRequestMethodGET,
 * 								Uri:    "https://resthealth.healthservice.com/api/services/contosoService/healthStatus",
 * 							},
 * 							Response: {
 * 								Regex: {
 * 									MatchQuantifier: deploymentmanager.RestMatchQuantifierAll,
 * 									Matches: []string{
 * 										"(?i)Contoso-Service-EndToEnd",
 * 										"(?i)\"health_status\":((.|\n)*)\"(green)\"",
 * 									},
 * 								},
 * 								SuccessStatusCodes: []string{
 * 									"OK",
 * 								},
 * 							},
 * 						},
 * 					},
 * 					HealthyStateDuration: "PT2H",
 * 					MaxElasticDuration:   "PT30M",
 * 					Type:                 "REST",
 * 					WaitDuration:         "PT15M",
 * 				},
 * 				StepType: "HealthCheck",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StepName:          pulumi.String("healthCheckStep"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Step;
 * import com.pulumi.azurenative.deploymentmanager.StepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var step = new Step("step", StepArgs.builder()
 *             .location("centralus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("attributes", Map.ofEntries(
 *                     Map.entry("healthChecks",
 *                         Map.ofEntries(
 *                             Map.entry("name", "appHealth"),
 *                             Map.entry("request", Map.ofEntries(
 *                                 Map.entry("authentication", Map.ofEntries(
 *                                     Map.entry("in", "Query"),
 *                                     Map.entry("name", "Code"),
 *                                     Map.entry("type", "ApiKey"),
 *                                     Map.entry("value", "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==")
 *                                 )),
 *                                 Map.entry("method", "GET"),
 *                                 Map.entry("uri", "https://resthealth.healthservice.com/api/applications/contosoApp/healthStatus")
 *                             )),
 *                             Map.entry("response", Map.ofEntries(
 *                                 Map.entry("regex", Map.ofEntries(
 *                                     Map.entry("matchQuantifier", "All"),
 *                                     Map.entry("matches",
 *                                         "(?i)Contoso-App",
 *                                         """
 * (?i)"health_status":((.|
 * )*)"(green|yellow)"                                        """,
 *                                         "(?mi)^(\"application_host\": 94781052)$")
 *                                 )),
 *                                 Map.entry("successStatusCodes", "OK")
 *                             ))
 *                         ),
 *                         Map.ofEntries(
 *                             Map.entry("name", "serviceHealth"),
 *                             Map.entry("request", Map.ofEntries(
 *                                 Map.entry("authentication", Map.ofEntries(
 *                                     Map.entry("in", "Header"),
 *                                     Map.entry("name", "code"),
 *                                     Map.entry("type", "ApiKey"),
 *                                     Map.entry("value", "NBCapiMOBQyAAbCkeytoPadnvO0eGHmidwFz5rXpappznKp3Jt7LLg==")
 *                                 )),
 *                                 Map.entry("method", "GET"),
 *                                 Map.entry("uri", "https://resthealth.healthservice.com/api/services/contosoService/healthStatus")
 *                             )),
 *                             Map.entry("response", Map.ofEntries(
 *                                 Map.entry("regex", Map.ofEntries(
 *                                     Map.entry("matchQuantifier", "All"),
 *                                     Map.entry("matches",
 *                                         "(?i)Contoso-Service-EndToEnd",
 *                                         """
 * (?i)"health_status":((.|
 * )*)"(green)"                                        """)
 *                                 )),
 *                                 Map.entry("successStatusCodes", "OK")
 *                             ))
 *                         )),
 *                     Map.entry("healthyStateDuration", "PT2H"),
 *                     Map.entry("maxElasticDuration", "PT30M"),
 *                     Map.entry("type", "REST"),
 *                     Map.entry("waitDuration", "PT15M")
 *                 )),
 *                 Map.entry("stepType", "HealthCheck")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .stepName("healthCheckStep")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ### Create wait step
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var step = new AzureNative.DeploymentManager.Step("step", new()
 *     {
 *         Location = "centralus",
 *         Properties = new AzureNative.DeploymentManager.Inputs.WaitStepPropertiesArgs
 *         {
 *             Attributes = new AzureNative.DeploymentManager.Inputs.WaitStepAttributesArgs
 *             {
 *                 Duration = "PT20M",
 *             },
 *             StepType = "Wait",
 *         },
 *         ResourceGroupName = "myResourceGroup",
 *         StepName = "waitStep",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/deploymentmanager/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := deploymentmanager.NewStep(ctx, "step", &deploymentmanager.StepArgs{
 * 			Location: pulumi.String("centralus"),
 * 			Properties: deploymentmanager.WaitStepProperties{
 * 				Attributes: deploymentmanager.WaitStepAttributes{
 * 					Duration: "PT20M",
 * 				},
 * 				StepType: "Wait",
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroup"),
 * 			StepName:          pulumi.String("waitStep"),
 * 			Tags:              nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.deploymentmanager.Step;
 * import com.pulumi.azurenative.deploymentmanager.StepArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var step = new Step("step", StepArgs.builder()
 *             .location("centralus")
 *             .properties(Map.ofEntries(
 *                 Map.entry("attributes", Map.of("duration", "PT20M")),
 *                 Map.entry("stepType", "Wait")
 *             ))
 *             .resourceGroupName("myResourceGroup")
 *             .stepName("waitStep")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:deploymentmanager:Step waitStep /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DeploymentManager/steps/{stepName}
 * ```
 * @property location The geo-location where the resource lives
 * @property properties The properties that define the step.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property stepName The name of the deployment step.
 * @property tags Resource tags.
 */
public data class StepArgs(
    public val location: Output<String>? = null,
    public val properties: Output<Either<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>>? =
        null,
    public val resourceGroupName: Output<String>? = null,
    public val stepName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.StepArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.StepArgs =
        com.pulumi.azurenative.deploymentmanager.StepArgs.builder()
            .location(location?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .stepName(stepName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [StepArgs].
 */
@PulumiTagMarker
public class StepArgsBuilder internal constructor() {
    private var location: Output<String>? = null

    private var properties: Output<Either<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>>? =
        null

    private var resourceGroupName: Output<String>? = null

    private var stepName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("javiqkmtsyrlfdov")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The properties that define the step.
     */
    @JvmName("knaosbqrmvhttqqi")
    public suspend
    fun properties(`value`: Output<Either<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>>) {
        this.properties = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cqmvnnijyfcmlahe")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the deployment step.
     */
    @JvmName("gxtsfjfksyhgfmlc")
    public suspend fun stepName(`value`: Output<String>) {
        this.stepName = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("xjvoqakhhosjtqtn")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("qtniwxwwfnjcifim")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The properties that define the step.
     */
    @JvmName("cmagsuwlxuegjyfb")
    public suspend
    fun properties(`value`: Either<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that define the step.
     */
    @JvmName("aoypkodunrivvtqm")
    public fun properties(`value`: HealthCheckStepPropertiesArgs) {
        val toBeMapped = Either.ofLeft<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The properties that define the step.
     */
    @JvmName("dijvhyamqerekctk")
    public fun properties(`value`: WaitStepPropertiesArgs) {
        val toBeMapped = Either.ofRight<HealthCheckStepPropertiesArgs, WaitStepPropertiesArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("xtvkrqvfqryauqfm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the deployment step.
     */
    @JvmName("caonldqpqprbncwx")
    public suspend fun stepName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stepName = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("jtnpfmcngwyttgas")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("kyeasscimqqquglj")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): StepArgs = StepArgs(
        location = location,
        properties = properties,
        resourceGroupName = resourceGroupName,
        stepName = stepName,
        tags = tags,
    )
}
