@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.ApiKeyAuthenticationArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.enums.RestAuthLocation
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ApiKey authentication gives a name and a value that can be included in either the request header or query parameters.
 * @property in The location of the authentication key/value pair in the request.
 * @property name The key name of the authentication key/value pair.
 * @property type The authentication type.
 * Expected value is 'ApiKey'.
 * @property value The value of the authentication key/value pair.
 */
public data class ApiKeyAuthenticationArgs(
    public val `in`: Output<RestAuthLocation>,
    public val name: Output<String>,
    public val type: Output<String>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.ApiKeyAuthenticationArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.ApiKeyAuthenticationArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.ApiKeyAuthenticationArgs.builder()
            .`in`(`in`.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiKeyAuthenticationArgs].
 */
@PulumiTagMarker
public class ApiKeyAuthenticationArgsBuilder internal constructor() {
    private var `in`: Output<RestAuthLocation>? = null

    private var name: Output<String>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The location of the authentication key/value pair in the request.
     */
    @JvmName("wojiicwsajvibcan")
    public suspend fun `in`(`value`: Output<RestAuthLocation>) {
        this.`in` = value
    }

    /**
     * @param value The key name of the authentication key/value pair.
     */
    @JvmName("drpcnfkmlocnjbbd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The authentication type.
     * Expected value is 'ApiKey'.
     */
    @JvmName("mkbscstmypgjapes")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of the authentication key/value pair.
     */
    @JvmName("lipdksqmaiqaysar")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The location of the authentication key/value pair in the request.
     */
    @JvmName("wxmajcxytrixgmnf")
    public suspend fun `in`(`value`: RestAuthLocation) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`in` = mapped
    }

    /**
     * @param value The key name of the authentication key/value pair.
     */
    @JvmName("wjmxdlxgwaldfgvb")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The authentication type.
     * Expected value is 'ApiKey'.
     */
    @JvmName("nheadffewktqosbw")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of the authentication key/value pair.
     */
    @JvmName("fcfxwqpomykshyeg")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ApiKeyAuthenticationArgs = ApiKeyAuthenticationArgs(
        `in` = `in` ?: throw PulumiNullFieldException("in"),
        name = name ?: throw PulumiNullFieldException("name"),
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
