@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetArtifactSourcePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property artifactSourceName The name of the artifact source.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetArtifactSourcePlainArgs(
    public val artifactSourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetArtifactSourcePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetArtifactSourcePlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetArtifactSourcePlainArgs.builder()
            .artifactSourceName(artifactSourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetArtifactSourcePlainArgs].
 */
@PulumiTagMarker
public class GetArtifactSourcePlainArgsBuilder internal constructor() {
    private var artifactSourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the artifact source.
     */
    @JvmName("csgugqofwiugreix")
    public suspend fun artifactSourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.artifactSourceName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gsjlottroolqhera")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetArtifactSourcePlainArgs = GetArtifactSourcePlainArgs(
        artifactSourceName = artifactSourceName ?: throw PulumiNullFieldException("artifactSourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
