@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetRolloutPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property retryAttempt Rollout retry attempt ordinal to get the result of. If not specified, result of the latest attempt will be returned.
 * @property rolloutName The rollout name.
 */
public data class GetRolloutPlainArgs(
    public val resourceGroupName: String,
    public val retryAttempt: Int? = null,
    public val rolloutName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetRolloutPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetRolloutPlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetRolloutPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .retryAttempt(retryAttempt?.let({ args0 -> args0 }))
            .rolloutName(rolloutName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRolloutPlainArgs].
 */
@PulumiTagMarker
public class GetRolloutPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var retryAttempt: Int? = null

    private var rolloutName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bfqgatqnfjlubmce")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Rollout retry attempt ordinal to get the result of. If not specified, result of the latest attempt will be returned.
     */
    @JvmName("huwfslluawgfiwcw")
    public suspend fun retryAttempt(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.retryAttempt = mapped
    }

    /**
     * @param value The rollout name.
     */
    @JvmName("dfbufqyhmhmmumhb")
    public suspend fun rolloutName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rolloutName = mapped
    }

    internal fun build(): GetRolloutPlainArgs = GetRolloutPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        retryAttempt = retryAttempt,
        rolloutName = rolloutName ?: throw PulumiNullFieldException("rolloutName"),
    )
}
