@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetServicePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the service resource.
 * @property serviceTopologyName The name of the service topology .
 */
public data class GetServicePlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val serviceTopologyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetServicePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetServicePlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetServicePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServicePlainArgs].
 */
@PulumiTagMarker
public class GetServicePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var serviceTopologyName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("iyqnmctbkntkveqd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("mgqkvljdsfabaqyx")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("rupfscorpxdwctce")
    public suspend fun serviceTopologyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceTopologyName = mapped
    }

    internal fun build(): GetServicePlainArgs = GetServicePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        serviceTopologyName = serviceTopologyName ?: throw PulumiNullFieldException("serviceTopologyName"),
    )
}
