@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetServiceTopologyPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceTopologyName The name of the service topology .
 */
public data class GetServiceTopologyPlainArgs(
    public val resourceGroupName: String,
    public val serviceTopologyName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetServiceTopologyPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetServiceTopologyPlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetServiceTopologyPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceTopologyPlainArgs].
 */
@PulumiTagMarker
public class GetServiceTopologyPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceTopologyName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("cukxxdnwnhnfhihj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("fkbcixqbyrqxqbmi")
    public suspend fun serviceTopologyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceTopologyName = mapped
    }

    internal fun build(): GetServiceTopologyPlainArgs = GetServiceTopologyPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceTopologyName = serviceTopologyName ?: throw PulumiNullFieldException("serviceTopologyName"),
    )
}
