@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetServiceUnitPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property serviceName The name of the service resource.
 * @property serviceTopologyName The name of the service topology .
 * @property serviceUnitName The name of the service unit resource.
 */
public data class GetServiceUnitPlainArgs(
    public val resourceGroupName: String,
    public val serviceName: String,
    public val serviceTopologyName: String,
    public val serviceUnitName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetServiceUnitPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetServiceUnitPlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetServiceUnitPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 }))
            .serviceTopologyName(serviceTopologyName.let({ args0 -> args0 }))
            .serviceUnitName(serviceUnitName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetServiceUnitPlainArgs].
 */
@PulumiTagMarker
public class GetServiceUnitPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var serviceName: String? = null

    private var serviceTopologyName: String? = null

    private var serviceUnitName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("gstmdqfrxqkitpqg")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the service resource.
     */
    @JvmName("brrndnqajaogkgxy")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    /**
     * @param value The name of the service topology .
     */
    @JvmName("slqlfupruyjjomjb")
    public suspend fun serviceTopologyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceTopologyName = mapped
    }

    /**
     * @param value The name of the service unit resource.
     */
    @JvmName("xdotxqdprdgxuddc")
    public suspend fun serviceUnitName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceUnitName = mapped
    }

    internal fun build(): GetServiceUnitPlainArgs = GetServiceUnitPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
        serviceTopologyName = serviceTopologyName ?: throw PulumiNullFieldException("serviceTopologyName"),
        serviceUnitName = serviceUnitName ?: throw PulumiNullFieldException("serviceUnitName"),
    )
}
