@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.GetStepPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property stepName The name of the deployment step.
 */
public data class GetStepPlainArgs(
    public val resourceGroupName: String,
    public val stepName: String,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.GetStepPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.GetStepPlainArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.GetStepPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .stepName(stepName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetStepPlainArgs].
 */
@PulumiTagMarker
public class GetStepPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var stepName: String? = null

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("yfkkhhxekfytklvn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the deployment step.
     */
    @JvmName("bxnvrbfynwfxdytf")
    public suspend fun stepName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.stepName = mapped
    }

    internal fun build(): GetStepPlainArgs = GetStepPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        stepName = stepName ?: throw PulumiNullFieldException("stepName"),
    )
}
