@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.HealthCheckStepPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the properties of a health check step.
 * @property attributes The health check step attributes
 * @property stepType The type of step.
 * Expected value is 'HealthCheck'.
 */
public data class HealthCheckStepPropertiesArgs(
    public val attributes: Output<RestHealthCheckStepAttributesArgs>,
    public val stepType: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.HealthCheckStepPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.deploymentmanager.inputs.HealthCheckStepPropertiesArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.HealthCheckStepPropertiesArgs.builder()
            .attributes(attributes.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .stepType(stepType.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HealthCheckStepPropertiesArgs].
 */
@PulumiTagMarker
public class HealthCheckStepPropertiesArgsBuilder internal constructor() {
    private var attributes: Output<RestHealthCheckStepAttributesArgs>? = null

    private var stepType: Output<String>? = null

    /**
     * @param value The health check step attributes
     */
    @JvmName("mvtbhdunlclbydde")
    public suspend fun attributes(`value`: Output<RestHealthCheckStepAttributesArgs>) {
        this.attributes = value
    }

    /**
     * @param value The type of step.
     * Expected value is 'HealthCheck'.
     */
    @JvmName("jvogrdbvhywbedaj")
    public suspend fun stepType(`value`: Output<String>) {
        this.stepType = value
    }

    /**
     * @param value The health check step attributes
     */
    @JvmName("agjkepdiwrhsvsqm")
    public suspend fun attributes(`value`: RestHealthCheckStepAttributesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributes = mapped
    }

    /**
     * @param argument The health check step attributes
     */
    @JvmName("dmqrediebqsugasa")
    public suspend
    fun attributes(argument: suspend RestHealthCheckStepAttributesArgsBuilder.() -> Unit) {
        val toBeMapped = RestHealthCheckStepAttributesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributes = mapped
    }

    /**
     * @param value The type of step.
     * Expected value is 'HealthCheck'.
     */
    @JvmName("rgjuypgkqwqcqyge")
    public suspend fun stepType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepType = mapped
    }

    internal fun build(): HealthCheckStepPropertiesArgs = HealthCheckStepPropertiesArgs(
        attributes = attributes ?: throw PulumiNullFieldException("attributes"),
        stepType = stepType ?: throw PulumiNullFieldException("stepType"),
    )
}
