@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.IdentityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property identityIds The list of identities.
 * @property type The identity type.
 */
public data class IdentityArgs(
    public val identityIds: Output<List<String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.IdentityArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.IdentityArgs.builder()
            .identityIds(identityIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var identityIds: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The list of identities.
     */
    @JvmName("tecgirqilhdbnrrm")
    public suspend fun identityIds(`value`: Output<List<String>>) {
        this.identityIds = value
    }

    @JvmName("pooutlljkjsquckt")
    public suspend fun identityIds(vararg values: Output<String>) {
        this.identityIds = Output.all(values.asList())
    }

    /**
     * @param values The list of identities.
     */
    @JvmName("pfssnvtwctptvcro")
    public suspend fun identityIds(values: List<Output<String>>) {
        this.identityIds = Output.all(values)
    }

    /**
     * @param value The identity type.
     */
    @JvmName("ywoferxsaxgkobum")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The list of identities.
     */
    @JvmName("nnskrwvhtldtxpbi")
    public suspend fun identityIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityIds = mapped
    }

    /**
     * @param values The list of identities.
     */
    @JvmName("yoyhxnspkwvpceph")
    public suspend fun identityIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.identityIds = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("srtaplysurigpxvx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        identityIds = identityIds ?: throw PulumiNullFieldException("identityIds"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
