@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.PrePostStepArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that define a step.
 * @property stepId The resource Id of the step to be run.
 */
public data class PrePostStepArgs(
    public val stepId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.PrePostStepArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.PrePostStepArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.PrePostStepArgs.builder()
            .stepId(stepId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [PrePostStepArgs].
 */
@PulumiTagMarker
public class PrePostStepArgsBuilder internal constructor() {
    private var stepId: Output<String>? = null

    /**
     * @param value The resource Id of the step to be run.
     */
    @JvmName("xvvixqljvkuupprj")
    public suspend fun stepId(`value`: Output<String>) {
        this.stepId = value
    }

    /**
     * @param value The resource Id of the step to be run.
     */
    @JvmName("liwdwxnatgexrjhj")
    public suspend fun stepId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.stepId = mapped
    }

    internal fun build(): PrePostStepArgs = PrePostStepArgs(
        stepId = stepId ?: throw PulumiNullFieldException("stepId"),
    )
}
