@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A REST based health check
 * @property name A unique name for this check.
 * @property request The request to the health provider.
 * @property response The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
 */
public data class RestHealthCheckArgs(
    public val name: Output<String>,
    public val request: Output<RestRequestArgs>,
    public val response: Output<RestResponseArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .request(request.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .response(response?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [RestHealthCheckArgs].
 */
@PulumiTagMarker
public class RestHealthCheckArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var request: Output<RestRequestArgs>? = null

    private var response: Output<RestResponseArgs>? = null

    /**
     * @param value A unique name for this check.
     */
    @JvmName("rhvybejapywvycbi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The request to the health provider.
     */
    @JvmName("rsjdbhadcttkbute")
    public suspend fun request(`value`: Output<RestRequestArgs>) {
        this.request = value
    }

    /**
     * @param value The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
     */
    @JvmName("ocmltslhffnvslos")
    public suspend fun response(`value`: Output<RestResponseArgs>) {
        this.response = value
    }

    /**
     * @param value A unique name for this check.
     */
    @JvmName("ulperncwaqgoxwdq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The request to the health provider.
     */
    @JvmName("yvtthdgcnavmiuml")
    public suspend fun request(`value`: RestRequestArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.request = mapped
    }

    /**
     * @param argument The request to the health provider.
     */
    @JvmName("cjekigdtbvcdlrvv")
    public suspend fun request(argument: suspend RestRequestArgsBuilder.() -> Unit) {
        val toBeMapped = RestRequestArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.request = mapped
    }

    /**
     * @param value The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
     */
    @JvmName("mrlhbfqbjfrcjxnd")
    public suspend fun response(`value`: RestResponseArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.response = mapped
    }

    /**
     * @param argument The expected response from the health provider. If no expected response is provided, the default is to expect the received response to have an HTTP status code of 200 OK.
     */
    @JvmName("vluiibqwffnrolni")
    public suspend fun response(argument: suspend RestResponseArgsBuilder.() -> Unit) {
        val toBeMapped = RestResponseArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.response = mapped
    }

    internal fun build(): RestHealthCheckArgs = RestHealthCheckArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        request = request ?: throw PulumiNullFieldException("request"),
        response = response,
    )
}
