@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckStepAttributesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines the REST health check step properties.
 * @property healthChecks The list of checks that form the health check step.
 * @property healthyStateDuration The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
 * @property maxElasticDuration The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
 * @property type The type of health check.
 * Expected value is 'REST'.
 * @property waitDuration The duration in ISO 8601 format for which health check waits idly without any checks.
 */
public data class RestHealthCheckStepAttributesArgs(
    public val healthChecks: Output<List<RestHealthCheckArgs>>,
    public val healthyStateDuration: Output<String>,
    public val maxElasticDuration: Output<String>? = null,
    public val type: Output<String>,
    public val waitDuration: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckStepAttributesArgs> {
    override fun toJava():
        com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckStepAttributesArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RestHealthCheckStepAttributesArgs.builder()
            .healthChecks(
                healthChecks.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .healthyStateDuration(healthyStateDuration.applyValue({ args0 -> args0 }))
            .maxElasticDuration(maxElasticDuration?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .waitDuration(waitDuration?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestHealthCheckStepAttributesArgs].
 */
@PulumiTagMarker
public class RestHealthCheckStepAttributesArgsBuilder internal constructor() {
    private var healthChecks: Output<List<RestHealthCheckArgs>>? = null

    private var healthyStateDuration: Output<String>? = null

    private var maxElasticDuration: Output<String>? = null

    private var type: Output<String>? = null

    private var waitDuration: Output<String>? = null

    /**
     * @param value The list of checks that form the health check step.
     */
    @JvmName("anodbjpbaobsbquu")
    public suspend fun healthChecks(`value`: Output<List<RestHealthCheckArgs>>) {
        this.healthChecks = value
    }

    @JvmName("xafthhkkomuekhwm")
    public suspend fun healthChecks(vararg values: Output<RestHealthCheckArgs>) {
        this.healthChecks = Output.all(values.asList())
    }

    /**
     * @param values The list of checks that form the health check step.
     */
    @JvmName("xhfjivsffjlnppei")
    public suspend fun healthChecks(values: List<Output<RestHealthCheckArgs>>) {
        this.healthChecks = Output.all(values)
    }

    /**
     * @param value The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
     */
    @JvmName("qncmwvugufggpjbx")
    public suspend fun healthyStateDuration(`value`: Output<String>) {
        this.healthyStateDuration = value
    }

    /**
     * @param value The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
     */
    @JvmName("jtjgrtbxfoeiybrj")
    public suspend fun maxElasticDuration(`value`: Output<String>) {
        this.maxElasticDuration = value
    }

    /**
     * @param value The type of health check.
     * Expected value is 'REST'.
     */
    @JvmName("rrmoydgjkhpgoxxw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The duration in ISO 8601 format for which health check waits idly without any checks.
     */
    @JvmName("niibpqapviifwexw")
    public suspend fun waitDuration(`value`: Output<String>) {
        this.waitDuration = value
    }

    /**
     * @param value The list of checks that form the health check step.
     */
    @JvmName("lnxvahgqnrbtyjih")
    public suspend fun healthChecks(`value`: List<RestHealthCheckArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthChecks = mapped
    }

    /**
     * @param argument The list of checks that form the health check step.
     */
    @JvmName("qdkfmjmxmdsenikx")
    public suspend fun healthChecks(argument: List<suspend RestHealthCheckArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RestHealthCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthChecks = mapped
    }

    /**
     * @param argument The list of checks that form the health check step.
     */
    @JvmName("askswedcxjcfpaam")
    public suspend fun healthChecks(vararg argument: suspend RestHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RestHealthCheckArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.healthChecks = mapped
    }

    /**
     * @param argument The list of checks that form the health check step.
     */
    @JvmName("jfrvohhxrryxcoin")
    public suspend fun healthChecks(argument: suspend RestHealthCheckArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RestHealthCheckArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.healthChecks = mapped
    }

    /**
     * @param values The list of checks that form the health check step.
     */
    @JvmName("apgjxywkmviljrgq")
    public suspend fun healthChecks(vararg values: RestHealthCheckArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthChecks = mapped
    }

    /**
     * @param value The duration in ISO 8601 format for which the resource is expected to be continuously healthy. If maxElasticDuration is specified, healthy state duration is enforced after the detection of first healthy signal.
     */
    @JvmName("meocwyulhktxhjut")
    public suspend fun healthyStateDuration(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.healthyStateDuration = mapped
    }

    /**
     * @param value The duration in ISO 8601 format for which the health check waits for the resource to become healthy. Health check fails if it doesn't. Health check starts to enforce healthyStateDuration once resource becomes healthy.
     */
    @JvmName("chmqxvwhplbwpnbm")
    public suspend fun maxElasticDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxElasticDuration = mapped
    }

    /**
     * @param value The type of health check.
     * Expected value is 'REST'.
     */
    @JvmName("omjdtwcqytgqhmae")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The duration in ISO 8601 format for which health check waits idly without any checks.
     */
    @JvmName("bdivaftuvpnenaee")
    public suspend fun waitDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.waitDuration = mapped
    }

    internal fun build(): RestHealthCheckStepAttributesArgs = RestHealthCheckStepAttributesArgs(
        healthChecks = healthChecks ?: throw PulumiNullFieldException("healthChecks"),
        healthyStateDuration = healthyStateDuration ?: throw
            PulumiNullFieldException("healthyStateDuration"),
        maxElasticDuration = maxElasticDuration,
        type = type ?: throw PulumiNullFieldException("type"),
        waitDuration = waitDuration,
    )
}
