@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RestRequestArgs.builder
import com.pulumi.azurenative.deploymentmanager.kotlin.enums.RestRequestMethod
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The properties that make up a REST request
 * @property authentication The authentication information required in the request to the health provider.
 * @property method The HTTP method to use for the request.
 * @property uri The HTTP URI to use for the request.
 */
public data class RestRequestArgs(
    public val authentication:
    Output<Either<ApiKeyAuthenticationArgs, RolloutIdentityAuthenticationArgs>>,
    public val method: Output<RestRequestMethod>,
    public val uri: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RestRequestArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.RestRequestArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RestRequestArgs.builder()
            .authentication(
                authentication.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .method(method.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .uri(uri.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RestRequestArgs].
 */
@PulumiTagMarker
public class RestRequestArgsBuilder internal constructor() {
    private var authentication:
        Output<Either<ApiKeyAuthenticationArgs, RolloutIdentityAuthenticationArgs>>? = null

    private var method: Output<RestRequestMethod>? = null

    private var uri: Output<String>? = null

    /**
     * @param value The authentication information required in the request to the health provider.
     */
    @JvmName("nbhgxaaemryltsrw")
    public suspend
    fun authentication(`value`: Output<Either<ApiKeyAuthenticationArgs, RolloutIdentityAuthenticationArgs>>) {
        this.authentication = value
    }

    /**
     * @param value The HTTP method to use for the request.
     */
    @JvmName("paybmisrbbsltplp")
    public suspend fun method(`value`: Output<RestRequestMethod>) {
        this.method = value
    }

    /**
     * @param value The HTTP URI to use for the request.
     */
    @JvmName("lwhqkcunmvfhfkrs")
    public suspend fun uri(`value`: Output<String>) {
        this.uri = value
    }

    /**
     * @param value The authentication information required in the request to the health provider.
     */
    @JvmName("oxsijvtfqbmogfae")
    public suspend
    fun authentication(`value`: Either<ApiKeyAuthenticationArgs, RolloutIdentityAuthenticationArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The authentication information required in the request to the health provider.
     */
    @JvmName("lukbkcbihhpsppip")
    public fun authentication(`value`: ApiKeyAuthenticationArgs) {
        val toBeMapped = Either.ofLeft<ApiKeyAuthenticationArgs,
            RolloutIdentityAuthenticationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The authentication information required in the request to the health provider.
     */
    @JvmName("cwbgvuohcoatlftk")
    public fun authentication(`value`: RolloutIdentityAuthenticationArgs) {
        val toBeMapped = Either.ofRight<ApiKeyAuthenticationArgs,
            RolloutIdentityAuthenticationArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authentication = mapped
    }

    /**
     * @param value The HTTP method to use for the request.
     */
    @JvmName("faaltskityrrwwbi")
    public suspend fun method(`value`: RestRequestMethod) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.method = mapped
    }

    /**
     * @param value The HTTP URI to use for the request.
     */
    @JvmName("xkvpmtpojrlxysmn")
    public suspend fun uri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uri = mapped
    }

    internal fun build(): RestRequestArgs = RestRequestArgs(
        authentication = authentication ?: throw PulumiNullFieldException("authentication"),
        method = method ?: throw PulumiNullFieldException("method"),
        uri = uri ?: throw PulumiNullFieldException("uri"),
    )
}
