@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.deploymentmanager.kotlin.inputs

import com.pulumi.azurenative.deploymentmanager.inputs.RestResponseArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties that make up the expected REST response
 * @property regex The regular expressions to match the response content with.
 * @property successStatusCodes The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
 */
public data class RestResponseArgs(
    public val regex: Output<RestResponseRegexArgs>? = null,
    public val successStatusCodes: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.deploymentmanager.inputs.RestResponseArgs> {
    override fun toJava(): com.pulumi.azurenative.deploymentmanager.inputs.RestResponseArgs =
        com.pulumi.azurenative.deploymentmanager.inputs.RestResponseArgs.builder()
            .regex(regex?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .successStatusCodes(
                successStatusCodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [RestResponseArgs].
 */
@PulumiTagMarker
public class RestResponseArgsBuilder internal constructor() {
    private var regex: Output<RestResponseRegexArgs>? = null

    private var successStatusCodes: Output<List<String>>? = null

    /**
     * @param value The regular expressions to match the response content with.
     */
    @JvmName("rtpkyebmxtqyghcx")
    public suspend fun regex(`value`: Output<RestResponseRegexArgs>) {
        this.regex = value
    }

    /**
     * @param value The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
     */
    @JvmName("fofnocmylccwxcpa")
    public suspend fun successStatusCodes(`value`: Output<List<String>>) {
        this.successStatusCodes = value
    }

    @JvmName("kwmmpkdwsouydbbu")
    public suspend fun successStatusCodes(vararg values: Output<String>) {
        this.successStatusCodes = Output.all(values.asList())
    }

    /**
     * @param values The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
     */
    @JvmName("asvvyovpvabyflin")
    public suspend fun successStatusCodes(values: List<Output<String>>) {
        this.successStatusCodes = Output.all(values)
    }

    /**
     * @param value The regular expressions to match the response content with.
     */
    @JvmName("disdobpffvlexdbx")
    public suspend fun regex(`value`: RestResponseRegexArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param argument The regular expressions to match the response content with.
     */
    @JvmName("qbqqiddlslbtwdyp")
    public suspend fun regex(argument: suspend RestResponseRegexArgsBuilder.() -> Unit) {
        val toBeMapped = RestResponseRegexArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.regex = mapped
    }

    /**
     * @param value The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
     */
    @JvmName("qgdbfmwnuiyntcrr")
    public suspend fun successStatusCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successStatusCodes = mapped
    }

    /**
     * @param values The HTTP status codes expected in a successful health check response. The response is expected to match one of the given status codes. If no expected status codes are provided, default expected status code is 200 OK.
     */
    @JvmName("wbptbegjalmfywqy")
    public suspend fun successStatusCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.successStatusCodes = mapped
    }

    internal fun build(): RestResponseArgs = RestResponseArgs(
        regex = regex,
        successStatusCodes = successStatusCodes,
    )
}
